/* ***** BEGIN LICENSE BLOCK *****
 *   Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Initial Developer of the Original Code is
 * Canonical Ltd.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Evan Eveland <http://deskcut.mozdev.org>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */
/**
 *Global variable declaration
 */
var menu_items = new Array("save-webfav", "save-webfav-link");
var webfav_strings;
var save_path = "/tmp/webfav";
var desktop_fname = "webfav.desktop";
var default_favicon_fname = "favicon.ico";
window.addEventListener("load", initWebfav, false);

/**
 * initializer
 */
function initWebfav() {
    var menu = document.getElementById("contentAreaContextMenu");
    menu.addEventListener("popupshowing", menuListener, false);
    webfav_strings = document.getElementById("webfav_strings");
    if (!webfav_strings) {
        alert("no bundle");
    }

    // TODO: check first-time pref
    installToolbar();

}

/**
 * install a toolbar icon next to the urlbar
 */
function installToolbar() {
    try {

        var tbiId="webfav-button";
        var beforeEl = document.getElementById("urlbar-container");

        if(beforeEl) {
            var navBar = document.getElementById("nav-bar");
            if(document.getElementById(tbiId) == null) {
                navBar.insertItem(tbiId, beforeEl, null, false);
                navBar.setAttribute("currentset", navBar.currentSet );
                document.persist("nav-bar", "currentset");
            }
        }

    } catch(e) {
        alert('error installing toolbar:' + e);
    }
}

/**
 * menu listener
 */
function menuListener() {

    if(gContextMenu) {
        for(var i=0; i < menu_items.length; i++) {
            var menuitem = document.getElementById(menu_items[i]);
            if(menuitem && (i == 0)) {
                menuitem.hidden = (gContextMenu.isTextSelected || gContextMenu.onLink || gContextMenu.onImage || gContextMenu.onTextInput );
            } else if (menuitem) {
                menuitem.hidden = ! gContextMenu.onLink;
            }
        }
    }
    menuitem = null;
}

/**
 * Save the web favorite
 */
function saveWebFav(isLink) {
    //alert('in saveWebFav');

    var href;
    var shortcut_name;
    if (isLink && gContextMenu) {
        try {
            href = gContextMenu.linkURL();
        } catch(e) {
            href = gContextMenu.linkURL;
        } 
        shortcut_name = gContextMenu.linkText();

    } else {
        href = gBrowser.currentURI.spec;
        shortcut_name = gBrowser.contentDocument.title;
    }

    // if shortcut_name is blank, use the href
    if (shortcut_name == "") {
        shortcut_name = href;
    }

    createShortcut(href, save_path + "/" + desktop_fname, shortcut_name);

}

/**
 * create the desktop file and save favicon
 */
function createShortcut(url,path,name) {
    try {

        var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);

        var filePath = path;
        file.initWithPath (filePath);

        if (!file.exists()) {
            file.create(0x00, 0644);
        } else {
            file.remove(false);      
            file.initWithPath (filePath);
            file.create(0x00, 0644);
        }

        var outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
        outputStream.init(file, 0x20 | 0x02, 00004,null);

        var faviconURL = getFaviconURL();
        var faviconName = "";
        //alert('favicon=' + faviconURL);
        if (faviconURL != "") {
            var uriObject = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService).newURI(faviconURL, null, null);
            try {
                faviconName = getDefaultFileName(null, uriObject, null, null);
            }
            catch (e) {
                faviconName = getDefaultFileName(null, null, uriObject, null);
            }
        }

        // make the desktop file
        var output = "[Desktop Entry]\nEncoding=UTF-8\nName=" + cleanName(name) + "\nType=Link\nURL=" + url + "\nIcon=" + faviconName +"\n";

        var result = outputStream.write( output, output.length );
        outputStream.flush();
        outputStream.close();
        saveFavicon(faviconURL, faviconName, uriObject);
        return true;

    }
    catch (ex) {
        alert('error in createShortcut: '+ex);
        return false;
    }
}


/**
 * get the url that represents the favicon
 */
function getFaviconURL() {
    try {
        var theHead = content.document.getElementsByTagName("head");
        //alert('head len=' + theHead.length);
        if (theHead.length > 0) {
            var links = theHead[0].getElementsByTagName("link");
            for (var i=0; i<links.length; i++) {
                var link = links[i];
                if (link.type.indexOf("image/") == 0 || link.rel=="shortcut icon" || link.rel=="icon") {
                    return link.href;
                } 

            }
        }

        //if got here, just use standard favicon.icon location
        return content.document.location.protocol + "//" + content.document.location.hostname + "/" + default_favicon_fname;

    } catch (e) {
        alert('in getFavicon error=' + e);
    }

    return "";
}

/**
 * save the favicon assoicated with the url
 */
function saveFavicon (url, iconName, uriObject)
{
    //alert("favicon url=" + url + " iconName=" + iconName);

    if (url == "") {
        return;
    }

    try {
        var fileObject = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
        //alert('default fileName=' + iconName);

        fileObject.initWithPath(save_path + "/" + iconName);

        if (!fileObject.exists()) {
            fileObject.create(0x00, 0644);
        } else {
            fileObject.remove(false);
            fileObject.initWithPath(save_path + "/" + iconName);
            fileObject.create(0x00, 0644);
        }


        // make binary input stream to read from
        var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
        var channel = ioService.newChannelFromURI(ioService.newURI(url, null, null));
        var bInputStream = Components.classes["@mozilla.org/binaryinputstream;1"].createInstance(Components.interfaces.nsIBinaryInputStream);
        bInputStream.setInputStream(channel.open());

        // make file output stream to write to
        var writeFlag = 0x02; // write only
        var createFlag = 0x08; // create
        var truncateFlag = 0x20; // truncate
        var fileOutputStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
        fileOutputStream.init(fileObject, writeFlag | createFlag | truncateFlag, 0664, null);

        // write inputStream to outputStream
        var avail = bInputStream.available();
        while (avail > 0) {
            var bytes = bInputStream.readBytes(avail);
            fileOutputStream.write(bytes, avail);
            avail = bInputStream.available();
        }

        fileOutputStream.close();

    }
    catch (ef) {
        //alert('problems in saveFavicon' + ef);
    }
}

/**
 * cleanup the shortcut name
 */
function cleanName(filename) {
    filename = filename.replace(/[\\\/\:\*\?\"\<\>\|]/g, '');
    filename = filename.replace(/(^[\s]+)|([\s]+$)/g, '');
    return filename;
}

/**
 * Get the string bundle
 */
function getBundle (strName) {
    var retVal = "";
    if (webfav_strings) {
        try {
            retVal = webfav_strings.getString(strName);
        } catch (e) {
        }
    }
    return retVal;
}
