/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.sei;

import com.sun.xml.ws.client.sei.ValueSetter;
import com.sun.xml.ws.model.ParameterImpl;
import javax.xml.ws.WebServiceException;

abstract class ValueSetterFactory {
    static final ValueSetterFactory SYNC = new ValueSetterFactory(){

        ValueSetter get(ParameterImpl p) {
            return ValueSetter.getSync(p);
        }
    };
    static final ValueSetterFactory NONE = new ValueSetterFactory(){

        ValueSetter get(ParameterImpl p) {
            throw new WebServiceException("This shouldn't happen. No response parameters.");
        }
    };
    static final ValueSetterFactory SINGLE = new ValueSetterFactory(){

        ValueSetter get(ParameterImpl p) {
            return ValueSetter.SINGLE_VALUE;
        }
    };

    ValueSetterFactory() {
    }

    abstract ValueSetter get(ParameterImpl var1);

    static final class AsyncBeanValueSetterFactory
    extends ValueSetterFactory {
        private Class asyncBean;

        AsyncBeanValueSetterFactory(Class asyncBean) {
            this.asyncBean = asyncBean;
        }

        ValueSetter get(ParameterImpl p) {
            return new ValueSetter.AsyncBeanValueSetter(p, this.asyncBean);
        }
    }
}

