"""
Useful auxilliary data structures for query construction. Not useful outside
the SQL domain.
"""

class EmptyResultSet(Exception):
    pass

class FullResultSet(Exception):
    pass

class MultiJoin(Exception):
    """
    Used by join construction code to indicate the point at which a
    multi-valued join was attempted (if the caller wants to treat that
    exceptionally).
    """
    def __init__(self, level):
        self.level = level

class Empty(object):
    pass

class RawValue(object):
    def __init__(self, value):
        self.value = value

class Date(object):
    """
    Add a date selection column.
    """
    def __init__(self, col, lookup_type, date_sql_func):
        self.col = col
        self.lookup_type = lookup_type
        self.date_sql_func = date_sql_func

    def relabel_aliases(self, change_map):
        c = self.col
        if isinstance(c, (list, tuple)):
            self.col = (change_map.get(c[0], c[0]), c[1])

    def as_sql(self, quote_func=None):
        if not quote_func:
            quote_func = lambda x: x
        if isinstance(self.col, (list, tuple)):
            col = '%s.%s' % tuple([quote_func(c) for c in self.col])
        else:
            col = self.col
        return self.date_sql_func(self.lookup_type, col)

