
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: help_menu.c 1407 2006-10-21 12:28:41Z mschwerin $
 *
 */
#include "config.h"

#include "filelist_menu.h"
#include "gui_utils.h"
#include "help_menu.h"
#include "i18n.h"
#include "main_menu.h"
#include "otk.h"
#include "oxine.h"
#include "playback_menu.h"


static void
show_buttons_cb (oxine_t * oxine, otk_cb_t cb)
{
    int y = 20;
    otk_widget_t *b;
    if (odk_current_is_playback_mode (oxine->odk)) {
        b = otk_text_button_new (oxine->otk, y, 545, 180, 35,
                                 _("Next Page"), cb, oxine);
        otk_widget_set_alignment (b, OTK_ALIGN_CENTER);
        y += 190;
    }
    {
        b = otk_text_button_new (oxine->otk, y, 545, 180, 35,
                                 _("Back"), backto_menu_cb, oxine);
        otk_widget_set_alignment (b, OTK_ALIGN_CENTER);
        otk_widget_set_focus (b);
    }
}


static void
show_help_menu_second_page_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;

    hide_user_interface (oxine);
    show_menu_background (OXINE_BACKGROUNDS "/helpmenu.png");
    create_new_window (false, true);

    int x0 = 20;
    int x1 = 510;
    int x2 = 540;
    int y = 100;
    int a = OTK_ALIGN_LEFT | OTK_ALIGN_TOP;
    int w0 = x1 - x0 - 20;
    int w1 = 780 - x1;

    otk_label_new (oxine->otk, x0, y, w0, a, _("fast rewind / foreward"));
    otk_label_new (oxine->otk, x1, y, w1, a, _("Ctrl + left/ right"));

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a, _("seek backward/ foreward"));
    otk_label_new (oxine->otk, x1, y, w1, a, _("Ctrl + Alt + left/ right"));

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a, _("adjust stream speed"));
    otk_label_new (oxine->otk, x1, y, w1, a, "Ctrl + up/ down");

    y += 50;
    otk_label_new (oxine->otk, x0, y, w0, a, _("toggle mute/ unmute"));
    otk_label_new (oxine->otk, x1, y, w1, a, "m");

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a, _("adjust volume"));
    otk_label_new (oxine->otk, x1, y, w1, a, "+");
    otk_label_new (oxine->otk, x2, y, w1, a, "/ -");

    y += 50;
    otk_label_new (oxine->otk, x0, y, w0, a, _("change audio language"));
    otk_label_new (oxine->otk, x1, y, w1, a, "x");
    otk_label_new (oxine->otk, x2, y, w1, a, "/ X");

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a, _("adjust audio offset"));
    otk_label_new (oxine->otk, x1, y, w1, a, "c");
    otk_label_new (oxine->otk, x2, y, w1, a, "/ C");

    y += 50;
    otk_label_new (oxine->otk, x0, y, w0, a, _("change subtitle language"));
    otk_label_new (oxine->otk, x1, y, w1, a, "r");
    otk_label_new (oxine->otk, x2, y, w1, a, "/ R");

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a, _("adjust subtitle offset"));
    otk_label_new (oxine->otk, x1, y, w1, a, "t");
    otk_label_new (oxine->otk, x2, y, w1, a, "/ T");

    y += 50;
    otk_label_new (oxine->otk, x0, y, w0, a, _("toggle aspect ratio"));
    otk_label_new (oxine->otk, x1, y, w1, a, "a");

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a, _("toggle deinterlace"));
    otk_label_new (oxine->otk, x1, y, w1, a, "i");

    show_buttons_cb (oxine, show_help_menu_cb);

    oxine->current_menu = show_help_menu_second_page_cb;
    show_user_interface (oxine);
}


void
show_help_menu_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;

    hide_user_interface (oxine);
    show_menu_background (OXINE_BACKGROUNDS "/helpmenu.png");
    create_new_window (false, true);

    int x0 = 20;
    int x1 = 510;
    int x2 = 540;
    int y = 100;
    int a = OTK_ALIGN_LEFT | OTK_ALIGN_TOP;
    int w0 = x1 - x0 - 20;
    int w1 = 780 - x1;

    otk_label_new (oxine->otk, x0, y, w0, a, _("navigate the menus"));
    otk_label_new (oxine->otk, x1, y, w1, a, _("arrow keys"));

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a,
                   _("activate an item or a button"));
    otk_label_new (oxine->otk, x1, y, w1, a, _("Enter"));

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a, _("select an item in a list"));
    otk_label_new (oxine->otk, x1, y, w1, a, _("Space"));

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a, _("go back/ go up one level"));
    otk_label_new (oxine->otk, x1, y, w1, a, _("Esc/ Backspace"));

    if (odk_current_is_playback_mode (oxine->odk)
        && odk_current_has_video (oxine->odk)) {
        y += 30;
        otk_label_new (oxine->otk, x0, y, w0, a, _("show/ hide the OSD"));
        otk_label_new (oxine->otk, x1, y, w1, a, "o");
    }

    y += 50;
    if (odk_current_is_playback_mode (oxine->odk)
        && odk_current_is_dvd (oxine->odk)) {
        otk_label_new (oxine->otk, x0, y, w0, a, _("go to the DVD menus"));
        otk_label_new (oxine->otk, x1, y, w1, a, "F1-F7");
        y += 30;
    }

    if (odk_current_is_playback_mode (oxine->odk)) {
        otk_label_new (oxine->otk, x0, y, w0, a, _("show the playback menu"));
        otk_label_new (oxine->otk, x1, y, w1, a, "F9");
        y += 30;
    }

    otk_label_new (oxine->otk, x0, y, w0, a, _("show the main menu"));
    otk_label_new (oxine->otk, x1, y, w1, a, "F10");

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a, _("show the music menu"));
    otk_label_new (oxine->otk, x1, y, w1, a, "F11");

    y += 30;
    otk_label_new (oxine->otk, x0, y, w0, a, _("show the video menu"));
    otk_label_new (oxine->otk, x1, y, w1, a, "F12");

    if (odk_current_is_playback_mode (oxine->odk)) {
        y += 50;
        otk_label_new (oxine->otk, x0, y, w0, a, _("pause/ play"));
        otk_label_new (oxine->otk, x1, y, w1, a, _("Space"));

        y += 30;
        otk_label_new (oxine->otk, x0, y, w0, a, _("stop the stream"));
        otk_label_new (oxine->otk, x1, y, w1, a, "s");

        y += 30;
        if (odk_current_is_dvd (oxine->odk))
            otk_label_new (oxine->otk, x0, y, w0, a,
                           _("next/ previous chapter"));
        else if (odk_current_is_v4l (oxine->odk)
                 || odk_current_is_dvb (oxine->odk))
            otk_label_new (oxine->otk, x0, y, w0, a,
                           _("next/ previous channel"));
        else
            otk_label_new (oxine->otk, x0, y, w0, a,
                           _("next/ previous title"));
        otk_label_new (oxine->otk, x1, y, w1, a, "n");
        otk_label_new (oxine->otk, x2, y, w1, a, "/ p");
    }

    show_buttons_cb (oxine, show_help_menu_second_page_cb);

    oxine->current_menu = show_help_menu_cb;
    show_user_interface (oxine);
}
