/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_ICON_TILE_H_
#define _NL_ICON_TILE_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/clutk.h>

#define NL_TYPE_ICON_TILE (nl_icon_tile_get_type ())

#define NL_ICON_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_ICON_TILE, NlIconTile))

#define NL_ICON_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_ICON_TILE, NlIconTileClass))

#define NL_IS_ICON_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_ICON_TILE))

#define NL_IS_ICON_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_ICON_TILE))

#define NL_ICON_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_ICON_TILE, NlIconTileClass))

#define NL_ICON_TILE_ICON_SIZE 48

typedef struct _NlIconTile        NlIconTile;
typedef struct _NlIconTileClass   NlIconTileClass;
typedef struct _NlIconTilePrivate NlIconTilePrivate;
 
struct _NlIconTile
{
  CtkButton        parent;	

  NlIconTilePrivate *priv;
};

struct _NlIconTileClass
{
  CtkButtonClass   parent_class;

  void (*begin_drag_move) (NlIconTile *tile);
  void (*emblem_clicked)  (NlIconTile *tile);
};

typedef enum
{
  NL_ICON_TILE_EMBLEM_TYPE_HOVER,
  NL_ICON_TILE_EMBLEM_TYPE_ALWAYS
} NlIconTileEmblemType;

GType          nl_icon_tile_get_type   (void) G_GNUC_CONST;

ClutterActor * nl_icon_tile_new        (const gchar *title,
                                              const gchar *tooltip,
                                              GdkPixbuf   *icon);
void           nl_icon_tile_set_emblem (NlIconTile  *tile,
                                        NlIconTileEmblemType type,
                                        ClutterActor *emblem);


G_END_DECLS

#endif /* _NL_ICON_TILE_H_ */

