#!/bin/sh

ACTION="$1"
[ -z "$ACTION" ] && ACTION="install"

CONFIGFILE=/etc/update-manager/release-upgrades
ORIGFILE=/etc/update-manager/release-upgrades.orig

PREFIX="Prompt="

NEVER="never"
NORMAL="normal"
LTS="lts"

# $1: file path
getCurrentConfig() {
    [ ! -f "$1" ] && return 1
    grep "^$PREFIX" "$1" | sed "s/^$PREFIX\(.*\)$/\1/"
}

# $1: file path
# $2: target prompt mode
updateConfig() {
    [ ! -f "$1" ] && return 1
    [ -z "$2" ] && return 1

    sed -i "s/^$PREFIX.*$/$PREFIX$2/" "$1"
}

[ "$ACTION" = "install" ] && {
    orig=`getCurrentConfig $ORIGFILE` || exit 0

    [ -z "$orig" ] && exit 0

    [ "$orig" = "$LTS" ] && {
        updateConfig $CONFIGFILE $NEVER || exit 0
    } || {
        updateConfig $CONFIGFILE $orig || exit 0
    }
} || {
    curr=`getCurrentConfig $CONFIGFILE` || exit 0

    [ -z "$curr" ] && exit 0

    [ "$curr" != "$NEVER" ] && {
        updateConfig $ORIGFILE $curr || exit 0
    }
}
exit 0
