/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.powermock.core.MockRepository;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.classloader.annotations.MockPolicy;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.mockpolicies.MockPolicyClassLoadingSettings;
import org.powermock.mockpolicies.MockPolicyInterceptionSettings;
import org.powermock.mockpolicies.impl.MockPolicyClassLoadingSettingsImpl;
import org.powermock.mockpolicies.impl.MockPolicyInterceptionSettingsImpl;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.MockPolicyInitializer;

public class MockPolicyInitializerImpl
implements MockPolicyInitializer {
    private final PowerMockPolicy[] mockPolicies;
    private final Class<? extends PowerMockPolicy>[] mockPolicyTypes;
    private final Class<?> testClass;

    public MockPolicyInitializerImpl(Class<? extends PowerMockPolicy>[] classArray) {
        this(classArray, false);
    }

    public MockPolicyInitializerImpl(Class<?> clazz) {
        this(MockPolicyInitializerImpl.getMockPolicies(clazz), clazz, false);
    }

    private MockPolicyInitializerImpl(Class<? extends PowerMockPolicy>[] classArray, boolean bl) {
        this(classArray, null, false);
    }

    private MockPolicyInitializerImpl(Class<? extends PowerMockPolicy>[] classArray, Class<?> clazz, boolean bl) {
        this.testClass = clazz;
        this.mockPolicyTypes = bl ? null : classArray;
        if (classArray == null) {
            this.mockPolicies = new PowerMockPolicy[0];
        } else {
            this.mockPolicies = new PowerMockPolicy[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                this.mockPolicies[i] = Whitebox.newInstance(classArray[i]);
            }
        }
    }

    @Override
    public boolean isPrepared(String string) {
        MockPolicyClassLoadingSettings mockPolicyClassLoadingSettings = this.getClassLoadingSettings();
        boolean bl = Arrays.binarySearch(mockPolicyClassLoadingSettings.getStaticInitializersToSuppress(), string) < 0;
        boolean bl2 = Arrays.binarySearch(mockPolicyClassLoadingSettings.getFullyQualifiedNamesOfClassesToLoadByMockClassloader(), string) < 0;
        return bl || bl2;
    }

    @Override
    public boolean needsInitialization() {
        MockPolicyClassLoadingSettings mockPolicyClassLoadingSettings = this.getClassLoadingSettings();
        return mockPolicyClassLoadingSettings.getStaticInitializersToSuppress().length > 0 || mockPolicyClassLoadingSettings.getFullyQualifiedNamesOfClassesToLoadByMockClassloader().length > 0;
    }

    @Override
    public void initialize(ClassLoader classLoader) {
        if (classLoader instanceof MockClassLoader) {
            this.initialize((MockClassLoader)classLoader);
        }
    }

    private void initialize(MockClassLoader mockClassLoader) {
        if (this.mockPolicies.length > 0) {
            Class<?>[] classArray;
            MockPolicyClassLoadingSettings mockPolicyClassLoadingSettings = this.getClassLoadingSettings();
            String[] stringArray = mockPolicyClassLoadingSettings.getFullyQualifiedNamesOfClassesToLoadByMockClassloader();
            mockClassLoader.addClassesToModify(stringArray);
            if (this.testClass == null) {
                throw new IllegalStateException("Internal error: testClass should never be null when calling initialize on a mock policy");
            }
            mockClassLoader.addClassesToModify(this.testClass.getName());
            for (Class<?> clazz : classArray = this.testClass.getDeclaredClasses()) {
                mockClassLoader.addClassesToModify(clazz.getName());
            }
            Class<?>[] classArray2 = this.testClass.getClasses();
            for (Class<?> object : classArray2) {
                mockClassLoader.addClassesToModify(object.getName());
            }
            for (String string : mockPolicyClassLoadingSettings.getStaticInitializersToSuppress()) {
                mockClassLoader.addClassesToModify(string);
                MockRepository.addSuppressStaticInitializer(string);
            }
            this.invokeInitializeInterceptionSettingsFromClassLoader(mockClassLoader);
        }
    }

    private void invokeInitializeInterceptionSettingsFromClassLoader(MockClassLoader mockClassLoader) {
        try {
            Class<?> clazz;
            int n = this.mockPolicyTypes.length;
            Object object = Array.newInstance(Class.class, n);
            for (int i = 0; i < n; ++i) {
                clazz = Class.forName(this.mockPolicyTypes[i].getName(), false, mockClassLoader);
                Array.set(object, i, clazz);
            }
            Class<?> clazz2 = Class.forName(this.getClass().getName(), false, mockClassLoader);
            clazz = Whitebox.invokeConstructor(clazz2, object, true);
            Whitebox.invokeMethod(clazz, "initializeInterceptionSettings", new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalStateException("PowerMock internal error: Failed to load class.", exception);
        }
    }

    private void initializeInterceptionSettings() {
        MockPolicyInterceptionSettings mockPolicyInterceptionSettings = this.getInterceptionSettings();
        for (Method method : mockPolicyInterceptionSettings.getMethodsToSuppress()) {
            MockRepository.addMethodToSuppress(method);
        }
        for (Map.Entry entry : mockPolicyInterceptionSettings.getProxiedMethods().entrySet()) {
            MockRepository.putMethodProxy((Method)entry.getKey(), (InvocationHandler)entry.getValue());
        }
        for (Map.Entry entry : mockPolicyInterceptionSettings.getStubbedMethods().entrySet()) {
            Method method = (Method)entry.getKey();
            Object v = entry.getValue();
            MockRepository.putMethodToStub(method, v);
        }
        for (Field field : mockPolicyInterceptionSettings.getFieldsToSuppress()) {
            MockRepository.addFieldToSuppress(field);
        }
        for (String string : mockPolicyInterceptionSettings.getFieldTypesToSuppress()) {
            MockRepository.addFieldTypeToSuppress(string);
        }
    }

    private MockPolicyInterceptionSettings getInterceptionSettings() {
        MockPolicyInterceptionSettingsImpl mockPolicyInterceptionSettingsImpl = new MockPolicyInterceptionSettingsImpl();
        for (PowerMockPolicy powerMockPolicy : this.mockPolicies) {
            powerMockPolicy.applyInterceptionPolicy(mockPolicyInterceptionSettingsImpl);
        }
        return mockPolicyInterceptionSettingsImpl;
    }

    private MockPolicyClassLoadingSettings getClassLoadingSettings() {
        MockPolicyClassLoadingSettingsImpl mockPolicyClassLoadingSettingsImpl = new MockPolicyClassLoadingSettingsImpl();
        for (PowerMockPolicy powerMockPolicy : this.mockPolicies) {
            powerMockPolicy.applyClassLoadingPolicy(mockPolicyClassLoadingSettingsImpl);
        }
        return mockPolicyClassLoadingSettingsImpl;
    }

    private static Class<? extends PowerMockPolicy>[] getMockPolicies(Class<?> clazz) {
        Class[] classArray = new Class[]{};
        if (clazz.isAnnotationPresent(MockPolicy.class)) {
            MockPolicy mockPolicy = clazz.getAnnotation(MockPolicy.class);
            classArray = mockPolicy.value();
        }
        return classArray;
    }
}

