/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.classloader.annotations.MockPolicy;
import org.powermock.core.classloader.annotations.PowerMockListener;
import org.powermock.core.classloader.annotations.PrepareEverythingForTest;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.PrepareOnlyThisForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.impl.MainMockTransformer;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.proxyframework.RegisterProxyFramework;
import org.powermock.tests.utils.ArrayMerger;
import org.powermock.tests.utils.IgnorePackagesExtractor;
import org.powermock.tests.utils.TestChunk;
import org.powermock.tests.utils.TestClassesExtractor;
import org.powermock.tests.utils.TestSuiteChunker;
import org.powermock.tests.utils.impl.ArrayMergerImpl;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;
import org.powermock.tests.utils.impl.PowerMockIgnorePackagesExtractorImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;
import org.powermock.tests.utils.impl.TestCaseEntry;
import org.powermock.tests.utils.impl.TestChunkImpl;

public abstract class AbstractTestSuiteChunkerImpl<T>
implements TestSuiteChunker {
    private static final int DEFAULT_TEST_LISTENERS_SIZE = 1;
    protected static final int NOT_INITIALIZED = -1;
    private static final int INTERNAL_INDEX_NOT_FOUND = -1;
    protected final TestClassesExtractor prepareForTestExtractor = new PrepareForTestExtractorImpl();
    protected final TestClassesExtractor suppressionExtractor = new StaticConstructorSuppressExtractorImpl();
    private final IgnorePackagesExtractor ignorePackagesExtractor = new PowerMockIgnorePackagesExtractorImpl();
    private final ArrayMerger arrayMerger = new ArrayMergerImpl();
    private final Class<?>[] testClasses;
    protected final Set<Class<?>> delegatesCreatedForTheseClasses = new LinkedHashSet();
    protected final List<T> delegates = new LinkedList<T>();
    protected final LinkedHashMap<Integer, List<Integer>> testAtDelegateMapper = new LinkedHashMap();
    private int currentTestIndex = -1;
    private final List<TestCaseEntry> internalSuites;
    protected volatile int testCount = -1;

    protected AbstractTestSuiteChunkerImpl(Class<?> clazz) throws Exception {
        this(new Class[]{clazz});
    }

    protected AbstractTestSuiteChunkerImpl(Class<?> ... classArray) throws Exception {
        this.testClasses = classArray;
        this.internalSuites = new LinkedList<TestCaseEntry>();
        for (Class<?> clazz : classArray) {
            this.chunkClass(clazz);
        }
    }

    protected Object getPowerMockTestListenersLoadedByASpecificClassLoader(Class<?> clazz, ClassLoader classLoader) {
        try {
            int n = 1;
            Class<?> clazz2 = null;
            try {
                clazz2 = Class.forName("org.powermock.api.extension.listener.AnnotationEnabler", false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                n = 0;
            }
            this.registerProxyframework(classLoader);
            Class<?> clazz3 = Class.forName(PowerMockTestListener.class.getName(), false, classLoader);
            Object object = null;
            if (clazz.isAnnotationPresent(PowerMockListener.class)) {
                PowerMockListener powerMockListener = clazz.getAnnotation(PowerMockListener.class);
                Class<? extends PowerMockTestListener>[] classArray = powerMockListener.value();
                if (classArray.length > 0) {
                    object = Array.newInstance(clazz3, classArray.length + n);
                    for (int i = 0; i < classArray.length; ++i) {
                        String string = classArray[i].getName();
                        Class<?> clazz4 = Class.forName(string, false, classLoader);
                        Array.set(object, i, Whitebox.newInstance(clazz4));
                    }
                }
            } else {
                object = Array.newInstance(clazz3, n);
            }
            if (clazz2 != null) {
                Array.set(object, Array.getLength(object) - 1, Whitebox.newInstance(clazz2));
            }
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("PowerMock internal error: Failed to load class.", classNotFoundException);
        }
    }

    private void registerProxyframework(ClassLoader classLoader) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.powermock.api.extension.proxyframework.ProxyFrameworkImpl", false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Extension API internal error: org.powermock.api.extension.proxyframework.ProxyFrameworkImpl could not be located in classpath.");
        }
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(RegisterProxyFramework.class.getName(), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        try {
            Whitebox.invokeMethod(clazz2, "registerProxyFramework", Whitebox.newInstance(clazz));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void chunkClass(Class<?> clazz) throws Exception {
        Object object;
        Object object2;
        ClassLoader classLoader = null;
        String[] stringArray = this.ignorePackagesExtractor.getPackagesToIgnore(clazz);
        if (clazz.isAnnotationPresent(PrepareEverythingForTest.class)) {
            classLoader = this.createNewClassloader(clazz, new String[]{"*"}, stringArray);
        } else {
            object2 = this.prepareForTestExtractor.getTestClasses(clazz);
            object = this.suppressionExtractor.getTestClasses(clazz);
            classLoader = this.createNewClassloader(clazz, this.arrayMerger.mergeArrays(String.class, new String[][]{object2, object}), stringArray);
        }
        this.registerProxyframework(classLoader);
        object2 = new LinkedList();
        object = new TestChunkImpl(classLoader, (List<Method>)object2);
        LinkedList<TestChunk> linkedList = new LinkedList<TestChunk>();
        linkedList.add((TestChunk)object);
        this.internalSuites.add(new TestCaseEntry(clazz, linkedList));
        this.initEntries(this.internalSuites);
        if (object2.isEmpty()) {
            this.internalSuites.get(0).getTestChunks().remove(0);
        }
    }

    @Override
    public ClassLoader createNewClassloader(Class<?> clazz, final String[] stringArray, final String[] stringArray2) {
        ClassLoader classLoader = null;
        if (!(stringArray != null && stringArray.length != 0 || this.hasMockPolicyProvidedClasses(clazz))) {
            classLoader = Thread.currentThread().getContextClassLoader();
        } else {
            ArrayList<MockTransformer> arrayList = new ArrayList<MockTransformer>();
            MainMockTransformer mainMockTransformer = new MainMockTransformer();
            arrayList.add(mainMockTransformer);
            classLoader = AccessController.doPrivileged(new PrivilegedAction<MockClassLoader>(){

                @Override
                public MockClassLoader run() {
                    return new MockClassLoader(stringArray, stringArray2);
                }
            });
            MockClassLoader mockClassLoader = (MockClassLoader)classLoader;
            mockClassLoader.setMockTransformerChain(arrayList);
            new MockPolicyInitializerImpl(clazz).initialize(classLoader);
        }
        return classLoader;
    }

    @Override
    public void createTestDelegators(Class<?> clazz, List<TestChunk> list) throws Exception {
        for (TestChunk testChunk : list) {
            ClassLoader classLoader = testChunk.getClassLoader();
            List<Method> list2 = testChunk.getTestMethodsToBeExecutedByThisClassloader();
            T t = this.createDelegatorFromClassloader(classLoader, clazz, list2);
            this.delegates.add(t);
        }
        this.delegatesCreatedForTheseClasses.add(clazz);
    }

    protected abstract T createDelegatorFromClassloader(ClassLoader var1, Class<?> var2, List<Method> var3) throws Exception;

    private void initEntries(List<TestCaseEntry> list) throws Exception {
        for (TestCaseEntry testCaseEntry : list) {
            Method[] methodArray;
            Class<?> clazz = testCaseEntry.getTestClass();
            for (Method method : methodArray = clazz.getMethods()) {
                Object object;
                if (!this.shouldExecuteTestForMethod(clazz, method)) continue;
                ++this.currentTestIndex;
                if (this.hasChunkAnnotation(method)) {
                    LinkedList<Method> linkedList = new LinkedList<Method>();
                    linkedList.add(method);
                    object = this.getStaticSuppressionClasses(clazz, method);
                    ClassLoader classLoader = null;
                    classLoader = method.isAnnotationPresent(PrepareEverythingForTest.class) ? this.createNewClassloader(clazz, new String[]{"*"}, this.ignorePackagesExtractor.getPackagesToIgnore(clazz)) : this.createNewClassloader(clazz, this.arrayMerger.mergeArrays(String.class, new String[][]{this.prepareForTestExtractor.getTestClasses(method), object}), this.ignorePackagesExtractor.getPackagesToIgnore(clazz));
                    TestChunkImpl testChunkImpl = new TestChunkImpl(classLoader, linkedList);
                    testCaseEntry.getTestChunks().add(testChunkImpl);
                    this.updatedIndexes();
                    continue;
                }
                testCaseEntry.getTestChunks().get(0).getTestMethodsToBeExecutedByThisClassloader().add(method);
                int n = this.internalSuites.size() - 1;
                object = this.testAtDelegateMapper.get(n);
                if (object == null) {
                    object = new LinkedList();
                    this.testAtDelegateMapper.put(n, (List<Integer>)object);
                }
                object.add(this.currentTestIndex);
            }
        }
    }

    private boolean hasChunkAnnotation(Method method) {
        return method.isAnnotationPresent(PrepareForTest.class) || method.isAnnotationPresent(SuppressStaticInitializationFor.class) || method.isAnnotationPresent(PrepareOnlyThisForTest.class) || method.isAnnotationPresent(PrepareEverythingForTest.class);
    }

    private String[] getStaticSuppressionClasses(Class<?> clazz, Method method) {
        String[] stringArray = method.isAnnotationPresent(SuppressStaticInitializationFor.class) ? this.suppressionExtractor.getTestClasses(method) : this.suppressionExtractor.getTestClasses(clazz);
        return stringArray;
    }

    private void updatedIndexes() {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(this.currentTestIndex);
        this.testAtDelegateMapper.put(this.internalSuites.size(), linkedList);
    }

    @Override
    public int getChunkSize() {
        return this.getTestChunks().size();
    }

    @Override
    public List<TestChunk> getTestChunks() {
        LinkedList<TestChunk> linkedList = new LinkedList<TestChunk>();
        for (TestCaseEntry testCaseEntry : this.internalSuites) {
            for (TestChunk testChunk : testCaseEntry.getTestChunks()) {
                linkedList.add(testChunk);
            }
        }
        return linkedList;
    }

    public int getInternalTestIndex(int n) {
        Set<Map.Entry<Integer, List<Integer>>> set = this.testAtDelegateMapper.entrySet();
        for (Map.Entry<Integer, List<Integer>> entry : set) {
            List<Integer> list = entry.getValue();
            int n2 = list.indexOf(n);
            if (n2 == -1) continue;
            return n2;
        }
        return -1;
    }

    public int getDelegatorIndex(int n) {
        int n2 = -1;
        Set<Map.Entry<Integer, List<Integer>>> set = this.testAtDelegateMapper.entrySet();
        for (Map.Entry<Integer, List<Integer>> entry : set) {
            if (!entry.getValue().contains(n)) continue;
            n2 = entry.getKey();
            break;
        }
        if (n2 == -1) {
            throw new RuntimeException("Internal error: Failed to find the delgator index.");
        }
        return n2;
    }

    @Override
    public List<TestChunk> getTestChunksEntries(Class<?> clazz) {
        for (TestCaseEntry testCaseEntry : this.internalSuites) {
            if (!testCaseEntry.getTestClass().equals(clazz)) continue;
            return testCaseEntry.getTestChunks();
        }
        return null;
    }

    public Class<?>[] getTestClasses() {
        return this.testClasses;
    }

    protected boolean hasMockPolicyProvidedClasses(Class<?> clazz) {
        boolean bl = false;
        if (clazz.isAnnotationPresent(MockPolicy.class)) {
            MockPolicy mockPolicy = clazz.getAnnotation(MockPolicy.class);
            Class<? extends PowerMockPolicy>[] classArray = mockPolicy.value();
            bl = new MockPolicyInitializerImpl(classArray).needsInitialization();
        }
        return bl;
    }
}

