/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Set;
import org.powermock.tests.utils.TestClassesExtractor;

public abstract class AbstractTestClassExtractor
implements TestClassesExtractor {
    @Override
    public final String[] getTestClasses(AnnotatedElement annotatedElement) {
        HashSet<String> hashSet = new HashSet<String>();
        if (annotatedElement instanceof Class) {
            Class clazz = (Class)annotatedElement;
            for (clazz = clazz.getSuperclass(); clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
                this.extractClassesAndAddThemToList(clazz, hashSet);
            }
        }
        this.extractClassesAndAddThemToList(annotatedElement, hashSet);
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private void extractClassesAndAddThemToList(AnnotatedElement annotatedElement, Set<String> set) {
        String[] stringArray = this.getClassesToModify(annotatedElement);
        if (stringArray != null) {
            for (String string : stringArray) {
                set.add(string);
            }
        }
    }

    protected abstract String[] getClassesToModify(AnnotatedElement var1);

    @Override
    public boolean isPrepared(AnnotatedElement annotatedElement, String string) {
        if (string == null) {
            throw new IllegalArgumentException("fullyQualifiedClassName cannot be null.");
        }
        String[] stringArray = this.getTestClasses(annotatedElement);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }
}

