/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.matcherstrategies;

import java.lang.reflect.Field;
import org.powermock.reflect.exceptions.FieldNotFoundException;
import org.powermock.reflect.internal.matcherstrategies.FieldMatcherStrategy;

public class FieldTypeMatcherStrategy
extends FieldMatcherStrategy {
    final Class<?> expectedFieldType;

    public FieldTypeMatcherStrategy(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("field type cannot be null.");
        }
        this.expectedFieldType = clazz;
    }

    @Override
    public boolean matches(Field field) {
        return this.expectedFieldType.equals(field.getType());
    }

    @Override
    public void notFound(Class<?> clazz, boolean bl) throws FieldNotFoundException {
        throw new FieldNotFoundException(String.format("No %s field of type \"%s\" could be found in the class hierarchy of %s.", bl ? "instance" : "static", this.expectedFieldType.getName(), clazz.getName()));
    }

    public String toString() {
        return "type " + this.expectedFieldType.getName();
    }
}

