/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.matcherstrategies;

import java.lang.reflect.Field;
import org.powermock.reflect.exceptions.FieldNotFoundException;
import org.powermock.reflect.internal.matcherstrategies.FieldTypeMatcherStrategy;
import org.powermock.reflect.internal.primitivesupport.PrimitiveWrapper;

public class AssignableFromFieldTypeMatcherStrategy
extends FieldTypeMatcherStrategy {
    private final Class<?> primitiveCounterpart;

    public AssignableFromFieldTypeMatcherStrategy(Class<?> clazz) {
        super(clazz);
        this.primitiveCounterpart = PrimitiveWrapper.getPrimitiveFromWrapperType(this.expectedFieldType);
    }

    @Override
    public boolean matches(Field field) {
        Class<?> clazz = field.getType();
        return clazz.isAssignableFrom(this.expectedFieldType) || this.primitiveCounterpart != null && clazz.isAssignableFrom(this.primitiveCounterpart);
    }

    @Override
    public void notFound(Class<?> clazz, boolean bl) throws FieldNotFoundException {
        throw new FieldNotFoundException(String.format("No %s field assignable from \"%s\" could be found in the class hierarchy of %s.", bl ? "instance" : "static", this.expectedFieldType.getName(), clazz.getName()));
    }

    @Override
    public String toString() {
        return "type " + (this.primitiveCounterpart == null ? this.expectedFieldType.getName() : this.primitiveCounterpart.getName());
    }
}

