/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.internal.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.junit.Rule;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.TestMethod;
import org.junit.rules.MethodRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.modules.junit4.internal.impl.PowerMockJUnit44RunnerDelegateImpl;
import org.powermock.reflect.Whitebox;

public class PowerMockJUnit47RunnerDelegateImpl
extends PowerMockJUnit44RunnerDelegateImpl {
    public boolean hasRules;

    public PowerMockJUnit47RunnerDelegateImpl(Class<?> clazz, String[] stringArray, PowerMockTestListener[] powerMockTestListenerArray) throws InitializationError {
        super(clazz, stringArray, powerMockTestListenerArray);
    }

    public PowerMockJUnit47RunnerDelegateImpl(Class<?> clazz, String[] stringArray) throws InitializationError {
        super(clazz, stringArray);
    }

    public PowerMockJUnit47RunnerDelegateImpl(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    @Override
    protected PowerMockJUnit44RunnerDelegateImpl.PowerMockJUnit44MethodRunner createPowerMockRunner(Object object, TestMethod testMethod, RunNotifier runNotifier, Description description, boolean bl) {
        return new PowerMockJUnit47MethodRunner(object, testMethod, runNotifier, description, bl);
    }

    protected class PowerMockJUnit47MethodRunner
    extends PowerMockJUnit44RunnerDelegateImpl.PowerMockJUnit44MethodRunner {
        private Throwable potentialTestFailure;

        protected PowerMockJUnit47MethodRunner(Object object, TestMethod testMethod, RunNotifier runNotifier, Description description, boolean bl) {
            super(object, testMethod, runNotifier, description, bl);
        }

        @Override
        public void executeTest(Method method, Object object, Runnable runnable) {
            Set<Field> set = Whitebox.getFieldsAnnotatedWith(object, Rule.class, new Class[0]);
            boolean bl = PowerMockJUnit47RunnerDelegateImpl.this.hasRules = !set.isEmpty();
            if (!PowerMockJUnit47RunnerDelegateImpl.this.hasRules) {
                this.executeTestInSuper(method, object, runnable);
            } else {
                int n = 0;
                for (Field field : set) {
                    ++n;
                    try {
                        MethodRule methodRule = (MethodRule)field.get(object);
                        Statement statement = methodRule.apply((Statement)new LastRuleTestExecutorStatement(n, set.size(), runnable, object, method), new FrameworkMethod(method), object);
                        statement.evaluate();
                    }
                    catch (Throwable throwable) {
                        super.handleException(this.testMethod, this.potentialTestFailure == null ? throwable : this.potentialTestFailure);
                    }
                }
            }
        }

        @Override
        protected void handleException(TestMethod testMethod, Throwable throwable) {
            if (PowerMockJUnit47RunnerDelegateImpl.this.hasRules) {
                this.potentialTestFailure = throwable;
            } else {
                super.handleException(testMethod, throwable);
            }
        }

        private void executeTestInSuper(Method method, Object object, Runnable runnable) {
            super.executeTest(method, object, runnable);
        }

        private final class LastRuleTestExecutorStatement
        extends Statement {
            private final Runnable test;
            private final Object testInstance;
            private final Method method;
            private final int noOfRules;
            private final int currentRule;

            private LastRuleTestExecutorStatement(int n, int n2, Runnable runnable, Object object, Method method) {
                this.currentRule = n;
                this.noOfRules = n2;
                this.test = runnable;
                this.testInstance = object;
                this.method = method;
            }

            public void evaluate() throws Throwable {
                if (this.currentRule == this.noOfRules) {
                    PowerMockJUnit47MethodRunner.this.executeTestInSuper(this.method, this.testInstance, this.test);
                    if (PowerMockJUnit47MethodRunner.this.potentialTestFailure != null) {
                        throw PowerMockJUnit47MethodRunner.this.potentialTestFailure;
                    }
                }
            }
        }
    }
}

