/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.internal.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.junit.Before;
import org.junit.internal.runners.ClassRoadie;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodRoadie;
import org.junit.internal.runners.TestClass;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.powermock.core.classloader.annotations.MockPolicy;
import org.powermock.core.classloader.annotations.PrepareEverythingForTest;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.modules.junit4.common.internal.PowerMockJUnitRunnerDelegate;
import org.powermock.modules.junit4.internal.impl.testcaseworkaround.PowerMockJUnit4MethodValidator;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.PowerMockTestNotifier;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;
import org.powermock.tests.utils.impl.PowerMockTestNotifierImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;

public class PowerMockJUnit44RunnerDelegateImpl
extends Runner
implements Filterable,
Sortable,
PowerMockJUnitRunnerDelegate {
    private final List<Method> testMethods;
    private final TestClass testClass;
    private final PowerMockTestNotifier powerMockTestNotifier;

    public PowerMockJUnit44RunnerDelegateImpl(Class<?> clazz, String[] stringArray, PowerMockTestListener[] powerMockTestListenerArray) throws InitializationError {
        this.powerMockTestNotifier = new PowerMockTestNotifierImpl(powerMockTestListenerArray == null ? new PowerMockTestListener[]{} : powerMockTestListenerArray);
        this.testClass = new TestClass(clazz);
        this.testMethods = this.getTestMethods(clazz, stringArray);
        this.validate();
    }

    public PowerMockJUnit44RunnerDelegateImpl(Class<?> clazz, String[] stringArray) throws InitializationError {
        this(clazz, stringArray, null);
    }

    public PowerMockJUnit44RunnerDelegateImpl(Class<?> clazz) throws InitializationError {
        this(clazz, null);
    }

    protected List<Method> getTestMethods(Class<?> clazz, String[] stringArray) {
        Method[] methodArray;
        if (stringArray == null || stringArray.length == 0) {
            try {
                return (List)Whitebox.invokeMethod((Object)this.testClass, "getTestMethods", new Object[0]);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : methodArray = clazz.getMethods()) {
            for (String string : stringArray) {
                if (!method.getName().equals(string)) continue;
                linkedList.add(method);
            }
        }
        return linkedList;
    }

    protected void validate() throws InitializationError {
        if (!TestCase.class.isAssignableFrom(this.testClass.getJavaClass())) {
            PowerMockJUnit4MethodValidator powerMockJUnit4MethodValidator = new PowerMockJUnit4MethodValidator(this.testClass);
            powerMockJUnit4MethodValidator.validateMethodsForDefaultRunner();
            powerMockJUnit4MethodValidator.assertValid();
        }
    }

    @Override
    public void run(final RunNotifier runNotifier) {
        new ClassRoadie(runNotifier, this.testClass, this.getDescription(), new Runnable(){

            @Override
            public void run() {
                PowerMockJUnit44RunnerDelegateImpl.this.runMethods(runNotifier);
            }
        }).runProtected();
    }

    protected void runMethods(RunNotifier runNotifier) {
        StaticConstructorSuppressExtractorImpl staticConstructorSuppressExtractorImpl = new StaticConstructorSuppressExtractorImpl();
        Class<?> clazz = this.getTestClass();
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!classLoader.equals(clazz.getClassLoader())) {
            try {
                clazz = classLoader.loadClass(clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Internal error in PowerMock", classNotFoundException);
            }
        }
        for (Method method : this.testMethods) {
            if (staticConstructorSuppressExtractorImpl.getTestClasses(method) == null) {
                staticConstructorSuppressExtractorImpl.getTestClasses(clazz);
            }
            this.invokeTestMethod(method, runNotifier);
        }
    }

    @Override
    public Description getDescription() {
        Description description = Description.createSuiteDescription((String)this.getName(), (Annotation[])this.classAnnotations());
        List<Method> list = this.testMethods;
        for (Method method : list) {
            description.addChild(this.methodDescription(method));
        }
        return description;
    }

    protected Annotation[] classAnnotations() {
        return this.getTestClass().getAnnotations();
    }

    protected String getName() {
        return this.getTestWrappedClass().getName();
    }

    protected Object createTest() throws Exception {
        return this.createTestInstance();
    }

    private Object createTestInstance() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        TestClass testClass = this.getTestWrappedClass();
        Constructor constructor = null;
        Class clazz = testClass.getJavaClass();
        if (TestCase.class.isAssignableFrom(clazz)) {
            constructor = TestSuite.getTestConstructor(clazz.asSubclass(TestCase.class));
            if (constructor.getParameterTypes().length == 1) {
                return constructor.newInstance(clazz.getSimpleName());
            }
        } else {
            constructor = testClass.getConstructor();
        }
        return constructor.newInstance(new Object[0]);
    }

    protected void invokeTestMethod(Method method, RunNotifier runNotifier) {
        Object object;
        Description description = this.methodDescription(method);
        try {
            object = this.createTest();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.testAborted(runNotifier, description, invocationTargetException.getTargetException());
            return;
        }
        catch (Exception exception) {
            this.testAborted(runNotifier, description, exception);
            return;
        }
        boolean bl = TestCase.class.isAssignableFrom(this.testClass.getJavaClass());
        TestMethod testMethod = this.wrapMethod(method);
        this.createPowerMockRunner(object, testMethod, runNotifier, description, bl).run();
    }

    protected PowerMockJUnit44MethodRunner createPowerMockRunner(Object object, TestMethod testMethod, RunNotifier runNotifier, Description description, boolean bl) {
        return new PowerMockJUnit44MethodRunner(object, testMethod, runNotifier, description, bl);
    }

    private void testAborted(RunNotifier runNotifier, Description description, Throwable throwable) {
        runNotifier.fireTestStarted(description);
        runNotifier.fireTestFailure(new Failure(description, throwable));
        runNotifier.fireTestFinished(description);
    }

    protected TestMethod wrapMethod(Method method) {
        return new TestMethod(method, this.testClass);
    }

    protected String testName(Method method) {
        return method.getName();
    }

    protected Description methodDescription(Method method) {
        return Description.createTestDescription((Class)this.getTestWrappedClass().getJavaClass(), (String)this.testName(method), (Annotation[])this.testAnnotations(method));
    }

    protected Annotation[] testAnnotations(Method method) {
        return method.getAnnotations();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<Method> iterator = this.testMethods.iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (filter.shouldRun(this.methodDescription(method))) continue;
            iterator.remove();
        }
        if (this.testMethods.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    public void sort(final Sorter sorter) {
        Collections.sort(this.testMethods, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                return sorter.compare(PowerMockJUnit44RunnerDelegateImpl.this.methodDescription(method), PowerMockJUnit44RunnerDelegateImpl.this.methodDescription(method2));
            }
        });
    }

    protected TestClass getTestWrappedClass() {
        return this.testClass;
    }

    @Override
    public int getTestCount() {
        return this.testMethods.size();
    }

    @Override
    public Class<?> getTestClass() {
        return this.testClass.getJavaClass();
    }

    protected class PowerMockJUnit44MethodRunner
    extends MethodRoadie {
        private final Object testInstance;
        private final boolean extendsFromTestCase;
        protected final TestMethod testMethod;

        protected PowerMockJUnit44MethodRunner(Object object, TestMethod testMethod, RunNotifier runNotifier, Description description, boolean bl) {
            super(object, testMethod, runNotifier, description);
            this.testInstance = object;
            this.extendsFromTestCase = bl;
            this.testMethod = testMethod;
        }

        public void runBeforesThenTestThenAfters(Runnable runnable) {
            this.executeTest(Whitebox.getInternalState((Object)this.testMethod, Method.class), this.testInstance, runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeTest(Method method, Object object, Runnable runnable) {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Thread thread = Thread.currentThread();
            ClassLoader classLoader2 = thread.getContextClassLoader();
            thread.setContextClassLoader(classLoader);
            new MockPolicyInitializerImpl(PowerMockJUnit44RunnerDelegateImpl.this.testClass.getJavaClass()).initialize(classLoader);
            PowerMockJUnit44RunnerDelegateImpl.this.powerMockTestNotifier.notifyBeforeTestMethod(object, method, new Object[0]);
            try {
                super.runBeforesThenTestThenAfters(runnable);
            }
            finally {
                thread.setContextClassLoader(classLoader2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTestMethod() {
            try {
                try {
                    Method method;
                    if (this.extendsFromTestCase && !(method = Whitebox.getMethod(this.testInstance.getClass(), "setUp", new Class[0])).isAnnotationPresent(Before.class)) {
                        Whitebox.invokeMethod(this.testInstance, "setUp", new Object[0]);
                    }
                    this.testMethod.invoke(this.testInstance);
                    if (((Boolean)Whitebox.invokeMethod((Object)this.testMethod, "expectsException", new Object[0])).booleanValue()) {
                        this.addFailure((Throwable)((Object)new AssertionError((Object)("Expected exception: " + this.getExpectedExceptionName(this.testMethod)))));
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.handleInvocationTargetException(this.testMethod, invocationTargetException);
                }
                catch (Throwable throwable) {
                    this.addFailure(throwable);
                }
                finally {
                    if (this.extendsFromTestCase) {
                        try {
                            Whitebox.invokeMethod(this.testInstance, "tearDown", new Object[0]);
                        }
                        catch (Throwable throwable) {
                            this.addFailure(throwable);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Internal error in PowerMock.", throwable);
            }
        }

        private void handleInvocationTargetException(TestMethod testMethod, InvocationTargetException invocationTargetException) throws Exception {
            Throwable throwable = invocationTargetException.getTargetException();
            while (throwable instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)throwable).getTargetException();
            }
            this.handleException(testMethod, throwable);
        }

        protected void handleException(TestMethod testMethod, Throwable throwable) {
            try {
                if (!((Boolean)Whitebox.invokeMethod((Object)testMethod, "expectsException", new Object[0])).booleanValue()) {
                    String string = throwable.getStackTrace()[0].getClassName();
                    Class clazz = PowerMockJUnit44RunnerDelegateImpl.this.testClass.getJavaClass();
                    if (!(!(throwable instanceof NullPointerException) || clazz.getName().equals(string) || string.startsWith("java.lang") || string.startsWith("org.powermock") || string.startsWith("org.junit") || new PrepareForTestExtractorImpl().isPrepared(clazz, string) || clazz.isAnnotationPresent(PrepareEverythingForTest.class) || new MockPolicyInitializerImpl(clazz.isAnnotationPresent(MockPolicy.class) ? clazz.getAnnotation(MockPolicy.class).value() : null).isPrepared(string))) {
                        Whitebox.setInternalState((Object)throwable, "detailMessage", (Object)("Perhaps the class " + string + " must be prepared for test?"), Throwable.class);
                    }
                    this.addFailure(throwable);
                } else if (((Boolean)Whitebox.invokeMethod((Object)testMethod, "isUnexpected", throwable)).booleanValue()) {
                    String string = "Unexpected exception, expected<" + this.getExpectedExceptionName(testMethod) + "> but was<" + throwable.getClass().getName() + ">";
                    this.addFailure(new Exception(string, throwable));
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("PowerMock internal error: Should never throw exception at this level", exception);
            }
        }

        private String getExpectedExceptionName(TestMethod testMethod) throws Exception {
            return ((Class)Whitebox.invokeMethod((Object)testMethod, "getExpectedException", new Object[0])).getName();
        }
    }
}

