/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.impl;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.InnerClassesAttribute;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.powermock.core.IndicateReloadClass;
import org.powermock.core.MockGateway;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.TransformStrategy;

public class MainMockTransformer
implements MockTransformer {
    private static final String VOID = "";
    private TransformStrategy strategy;

    public MainMockTransformer() {
        this(TransformStrategy.CLASSLOADER);
    }

    public MainMockTransformer(TransformStrategy transformStrategy) {
        this.strategy = transformStrategy;
    }

    @Override
    public CtClass transform(CtClass ctClass) throws Exception {
        if (ctClass.isFrozen()) {
            ctClass.defrost();
        }
        String string = this.allowMockingOfPackagePrivateClasses(ctClass);
        this.suppressStaticInitializerIfRequested(ctClass, string);
        if (ctClass.isInterface()) {
            return ctClass;
        }
        this.removeFinalModifierFromClass(ctClass);
        this.allowMockingOfStaticAndFinalAndNativeMethods(ctClass);
        this.setAllConstructorsToPublic(ctClass);
        this.removeFinalModifierFromAllStaticFinalFields(ctClass);
        if (this.strategy != TransformStrategy.INST_TRANSFORM) {
            ctClass.instrument((ExprEditor)new PowerMockExpressionEditor(ctClass));
        }
        ctClass.detach();
        return ctClass;
    }

    private String allowMockingOfPackagePrivateClasses(CtClass ctClass) {
        String string = ctClass.getName();
        if (this.strategy != TransformStrategy.INST_REDEFINE) {
            try {
                int n = ctClass.getModifiers();
                if (!(!Modifier.isPackage((int)n) || string.startsWith("java.") || ctClass.isInterface() && ctClass.getDeclaringClass() != null)) {
                    ctClass.setModifiers(Modifier.setPublic((int)n));
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return string;
    }

    private void suppressStaticInitializerIfRequested(CtClass ctClass, String string) throws CannotCompileException {
        if (this.strategy == TransformStrategy.CLASSLOADER && MockGateway.staticConstructorCall(string) != MockGateway.PROCEED) {
            CtConstructor ctConstructor = ctClass.makeClassInitializer();
            ctConstructor.setBody("{}");
        }
    }

    private void removeFinalModifierFromClass(CtClass ctClass) {
        if (this.strategy != TransformStrategy.INST_REDEFINE) {
            ClassFile classFile;
            AttributeInfo attributeInfo;
            if (Modifier.isFinal((int)ctClass.getModifiers())) {
                ctClass.setModifiers(ctClass.getModifiers() ^ 0x10);
            }
            if ((attributeInfo = (classFile = ctClass.getClassFile2()).getAttribute("InnerClasses")) != null && attributeInfo instanceof InnerClassesAttribute) {
                InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)attributeInfo;
                String string = classFile.getName();
                int n = innerClassesAttribute.tableLength();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    if (!string.equals(innerClassesAttribute.innerClass(i)) || !Modifier.isFinal((int)(n2 = innerClassesAttribute.accessFlags(i)))) continue;
                    innerClassesAttribute.setAccessFlags(i, n2 ^ 0x10);
                }
            }
        }
    }

    private void allowMockingOfStaticAndFinalAndNativeMethods(CtClass ctClass) throws NotFoundException, CannotCompileException {
        if (this.strategy != TransformStrategy.INST_TRANSFORM) {
            for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
                this.modifyMethod(ctMethod);
            }
        }
    }

    private void removeFinalModifierFromAllStaticFinalFields(CtClass ctClass) {
        if (this.strategy != TransformStrategy.INST_REDEFINE) {
            for (CtField ctField : ctClass.getDeclaredFields()) {
                int n = ctField.getModifiers();
                if (!Modifier.isFinal((int)n) || !Modifier.isStatic((int)n)) continue;
                ctField.setModifiers(n ^ 0x10);
            }
        }
    }

    private void setAllConstructorsToPublic(CtClass ctClass) {
        if (this.strategy == TransformStrategy.CLASSLOADER) {
            for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
                int n = ctConstructor.getModifiers();
                if (Modifier.isPublic((int)n)) continue;
                ctConstructor.setModifiers(Modifier.setPublic((int)n));
            }
        }
    }

    public void modifyMethod(CtMethod ctMethod) throws NotFoundException, CannotCompileException {
        if (!Modifier.isAbstract((int)ctMethod.getModifiers())) {
            CtClass ctClass = ctMethod.getReturnType();
            String string = this.getReturnTypeAsString(ctMethod);
            if (Modifier.isNative((int)ctMethod.getModifiers())) {
                String string2 = ctMethod.getName();
                String string3 = "($r)value";
                if (ctClass.equals(CtClass.voidType)) {
                    string3 = VOID;
                }
                String string4 = "this";
                if (Modifier.isStatic((int)ctMethod.getModifiers())) {
                    string4 = "$class";
                }
                ctMethod.setModifiers(ctMethod.getModifiers() - 256);
                String string5 = "Object value = " + MockGateway.class.getName() + ".methodCall(" + string4 + ", \"" + ctMethod.getName() + "\", $args, $sig, \"" + string + "\");" + "if (value != " + MockGateway.class.getName() + ".PROCEED) " + "return " + string3 + "; " + "throw new java.lang.UnsupportedOperationException(\"" + string2 + " is native\");";
                ctMethod.setBody("{" + string5 + "}");
                return;
            }
            String string6 = this.getCorrectReturnValueType(ctClass);
            String string7 = "this";
            if (Modifier.isStatic((int)ctMethod.getModifiers())) {
                string7 = "$class";
            }
            String string8 = "Object value = " + MockGateway.class.getName() + ".methodCall(" + string7 + ", \"" + ctMethod.getName() + "\", $args, $sig, \"" + string + "\");" + "if (value != " + MockGateway.class.getName() + ".PROCEED) " + "return " + string6 + "; ";
            ctMethod.insertBefore("{ " + string8 + "}");
        }
    }

    private String getReturnTypeAsString(CtMethod ctMethod) throws NotFoundException {
        CtClass ctClass = ctMethod.getReturnType();
        String string = VOID;
        if (!ctClass.equals(CtClass.voidType)) {
            string = ctClass.getName();
        }
        return string;
    }

    private String getCorrectReturnValueType(CtClass ctClass) {
        String string = ctClass.getName();
        String string2 = "($r)value";
        string2 = ctClass.equals(CtClass.voidType) ? VOID : (ctClass.isPrimitive() ? (string.equals("char") ? "((java.lang.Character)value).charValue()" : (string.equals("boolean") ? "((java.lang.Boolean)value).booleanValue()" : "((java.lang.Number)value)." + string + "Value()")) : "(" + string + ")value");
        return string2;
    }

    private final class PowerMockExpressionEditor
    extends ExprEditor {
        private final CtClass clazz;

        private PowerMockExpressionEditor(CtClass ctClass) {
            this.clazz = ctClass;
        }

        public void edit(FieldAccess fieldAccess) throws CannotCompileException {
            if (fieldAccess.isReader()) {
                CtClass ctClass;
                try {
                    ctClass = fieldAccess.getField().getType();
                }
                catch (NotFoundException notFoundException) {
                    if (MainMockTransformer.this.strategy != TransformStrategy.INST_REDEFINE) {
                        throw new RuntimeException("PowerMock internal error when modifying field.", notFoundException);
                    }
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("{Object value =  ").append(MockGateway.class.getName()).append(".fieldCall(").append("$0,$class,\"").append(fieldAccess.getFieldName()).append("\",$type);");
                stringBuilder.append("if(value == ").append(MockGateway.class.getName()).append(".PROCEED) {");
                stringBuilder.append("\t$_ = $proceed($$);");
                stringBuilder.append("} else {");
                stringBuilder.append("\t$_ = ").append(MainMockTransformer.this.getCorrectReturnValueType(ctClass)).append(";");
                stringBuilder.append("}}");
                fieldAccess.replace(stringBuilder.toString());
            }
        }

        public void edit(MethodCall methodCall) throws CannotCompileException {
            try {
                CtMethod ctMethod = methodCall.getMethod();
                CtClass ctClass = ctMethod.getDeclaringClass();
                if (ctClass != null && this.shouldTreatAsSystemClassCall(ctMethod, ctClass)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("{Object classOrInstance = null; if($0!=null){classOrInstance = $0;} else { classOrInstance = $class;}");
                    stringBuilder.append("Object value =  ").append(MockGateway.class.getName()).append(".methodCall(").append("classOrInstance,\"").append(methodCall.getMethodName()).append("\",$args, $sig,\"").append(MainMockTransformer.this.getReturnTypeAsString(ctMethod)).append("\");");
                    stringBuilder.append("if(value == ").append(MockGateway.class.getName()).append(".PROCEED) {");
                    stringBuilder.append("\t$_ = $proceed($$);");
                    stringBuilder.append("} else {");
                    String string = MainMockTransformer.this.getCorrectReturnValueType(ctMethod.getReturnType());
                    if (!MainMockTransformer.VOID.equals(string)) {
                        stringBuilder.append("\t$_ = ").append(string).append(";");
                    }
                    stringBuilder.append("}}");
                    methodCall.replace(stringBuilder.toString());
                }
            }
            catch (NotFoundException notFoundException) {
                if (MainMockTransformer.this.strategy != TransformStrategy.INST_REDEFINE) {
                    throw new RuntimeException("PowerMock internal error when modifying method.", notFoundException);
                }
                return;
            }
        }

        private boolean shouldTreatAsSystemClassCall(CtMethod ctMethod, CtClass ctClass) throws NotFoundException {
            String string = ctClass.getName();
            if (!string.startsWith("java.")) {
                return false;
            }
            int n = ctMethod.getModifiers();
            boolean bl = Modifier.isFinal((int)ctClass.getModifiers()) || Modifier.isFinal((int)n) || Modifier.isStatic((int)n) || Modifier.isNative((int)n);
            return bl || this.isJavaStandardMethod(ctMethod);
        }

        private boolean isJavaStandardMethod(CtMethod ctMethod) throws NotFoundException {
            String string = ctMethod.getName();
            CtClass[] ctClassArray = ctMethod.getParameterTypes();
            return string.equals("equals") && ctClassArray.length == 1 || string.equals("hashCode") && ctClassArray.length == 0 || string.equals("toString") && ctClassArray.length == 0;
        }

        public void edit(ConstructorCall constructorCall) throws CannotCompileException {
            if (MainMockTransformer.this.strategy != TransformStrategy.INST_REDEFINE && !constructorCall.getClassName().startsWith("java.lang")) {
                CtClass ctClass = null;
                try {
                    ctClass = this.clazz.getSuperclass();
                }
                catch (NotFoundException notFoundException) {
                    throw new RuntimeException(notFoundException);
                }
                this.addNewDeferConstructor(this.clazz);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("{Object value =").append(MockGateway.class.getName()).append(".constructorCall($class, $args, $sig);");
                stringBuilder.append("if (value != ").append(MockGateway.class.getName()).append(".PROCEED){");
                if (ctClass.getName().equals(Object.class.getName())) {
                    stringBuilder.append(" super();");
                } else {
                    stringBuilder.append(" super((" + IndicateReloadClass.class.getName() + ") null);");
                }
                stringBuilder.append("} else {");
                stringBuilder.append("   $proceed($$);");
                stringBuilder.append("}}");
                constructorCall.replace(stringBuilder.toString());
            }
        }

        private void addNewDeferConstructor(CtClass ctClass) throws CannotCompileException {
            CtClass ctClass2 = null;
            try {
                ctClass2 = ctClass.getSuperclass();
            }
            catch (NotFoundException notFoundException) {
                throw new IllegalArgumentException("Internal error: Failed to get superclass for " + ctClass.getName() + " when about to create a new default constructor.");
            }
            ClassPool classPool = ctClass.getClassPool();
            CtClass ctClass3 = null;
            try {
                ctClass3 = classPool.get(IndicateReloadClass.class.getName());
            }
            catch (NotFoundException notFoundException) {
                throw new IllegalArgumentException("Internal error: failed to get the " + IndicateReloadClass.class.getName() + " when added defer constructor.");
            }
            ctClass.defrost();
            if (ctClass2.getName().equals(Object.class.getName())) {
                try {
                    ctClass.addConstructor(CtNewConstructor.make((CtClass[])new CtClass[]{ctClass3}, (CtClass[])new CtClass[0], (String)"{super();}", (CtClass)ctClass));
                }
                catch (DuplicateMemberException duplicateMemberException) {}
            } else {
                this.addNewDeferConstructor(ctClass2);
                try {
                    ctClass.addConstructor(CtNewConstructor.make((CtClass[])new CtClass[]{ctClass3}, (CtClass[])new CtClass[0], (String)"{super($$);}", (CtClass)ctClass));
                }
                catch (DuplicateMemberException duplicateMemberException) {
                    // empty catch block
                }
            }
        }

        public void edit(NewExpr newExpr) throws CannotCompileException {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Object instance =").append(MockGateway.class.getName()).append(".newInstanceCall($type,$args,$sig);");
            stringBuilder.append("if(instance != ").append(MockGateway.class.getName()).append(".PROCEED) {");
            stringBuilder.append("\tif(instance instanceof java.lang.reflect.Constructor) {");
            stringBuilder.append("\t\t$_ = ($r) sun.reflect.ReflectionFactory.getReflectionFactory().newConstructorForSerialization($type, java.lang.Object.class.getDeclaredConstructor(null)).newInstance(null);");
            stringBuilder.append("\t} else {");
            stringBuilder.append("\t\t$_ = ($r) instance;");
            stringBuilder.append("\t}");
            stringBuilder.append("} else {");
            stringBuilder.append("\t$_ = $proceed($$);");
            stringBuilder.append("}");
            newExpr.replace(stringBuilder.toString());
        }
    }
}

