/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.WildcardMatcher;
import org.powermock.core.classloader.DeferSupportingClassLoader;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.core.transformers.MockTransformer;

public final class MockClassLoader
extends DeferSupportingClassLoader {
    public static final String MODIFY_ALL_CLASSES = "*";
    private List<MockTransformer> mockTransformerChain;
    private Set<String> modify = Collections.synchronizedSet(new HashSet());
    private final String[] packagesToLoadButNotModify = new String[]{"org.junit.", "junit.", "org.easymock.", "net.sf.cglib.", "javassist.", "org.powermock.modules.junit4.internal.", "org.powermock.modules.junit4.legacy.internal.", "org.powermock.modules.junit3.internal.", "org.powermock"};
    private final String[] specificClassesToLoadButNotModify = new String[]{InvocationSubstitute.class.getName(), PowerMockPolicy.class.getName(), ClassReplicaCreator.class.getName()};
    private static final String[] packagesToBeDeferred = new String[]{"org.hamcrest.*", "java.*", "javax.accessibility.*", "sun.*", "org.junit.*", "junit.*", "org.pitest.*", "org.powermock.modules.junit4.common.internal.*", "org.powermock.modules.junit3.internal.PowerMockJUnit3RunnerDelegate*", "org.powermock.core*"};
    private final String ignoredClass = "net.sf.cglib.proxy.Enhancer$EnhancerKey$$KeyFactoryByCGLIB$$";
    private final String ignoredClass2 = "net.sf.cglib.core.MethodWrapper$MethodWrapperKey$$KeyFactoryByCGLIB";
    private ClassPool classPool = new ClassPool();

    public MockClassLoader(String[] stringArray, String[] stringArray2) {
        super(MockClassLoader.class.getClassLoader(), MockClassLoader.getPackagesToDefer(stringArray2));
        this.addClassesToModify(stringArray);
        this.classPool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
    }

    private static String[] getPackagesToDefer(String[] stringArray) {
        int n = stringArray == null ? 0 : stringArray.length;
        int n2 = packagesToBeDeferred.length;
        int n3 = n2 + n;
        String[] stringArray2 = new String[n3];
        if (n3 > n2) {
            System.arraycopy(packagesToBeDeferred, 0, stringArray2, 0, n2);
            System.arraycopy(stringArray, 0, stringArray2, n2, n);
            return stringArray2;
        }
        return packagesToBeDeferred;
    }

    public MockClassLoader(String[] stringArray) {
        this(stringArray, new String[0]);
    }

    public void addClassesToModify(String ... stringArray) {
        for (String string : stringArray) {
            if (this.shouldDefer(packagesToBeDeferred, string)) continue;
            this.modify.add(string);
        }
    }

    @Override
    protected Class<?> loadModifiedClass(String string) throws ClassFormatError, ClassNotFoundException {
        Class<?> clazz = null;
        this.deferTo.loadClass(string);
        clazz = this.shouldModify(string) && !this.shouldLoadModified(string) ? this.loadMockClass(string) : this.loadUnmockedClass(string);
        return clazz;
    }

    private boolean shouldModify(String string) {
        return (this.shouldModifyAll() || WildcardMatcher.matchesAny(this.modify, string)) && !this.shouldIgnore(this.deferPackages, string);
    }

    public boolean shouldModifyAll() {
        return this.modify.size() == 1 && this.modify.iterator().next().equals(MODIFY_ALL_CLASSES);
    }

    private Class<?> loadUnmockedClass(String string) throws ClassFormatError, ClassNotFoundException {
        byte[] byArray = null;
        try {
            if (!string.startsWith("net.sf.cglib.proxy.Enhancer$EnhancerKey$$KeyFactoryByCGLIB$$") && !string.startsWith("net.sf.cglib.core.MethodWrapper$MethodWrapperKey$$KeyFactoryByCGLIB")) {
                CtClass ctClass = this.classPool.get(string);
                if (ctClass.isFrozen()) {
                    ctClass.defrost();
                }
                byArray = ctClass.toBytecode();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return byArray == null ? null : this.defineClass(string, byArray, 0, byArray.length);
    }

    private Class<?> loadMockClass(String string) {
        CtClass ctClass = null;
        byte[] byArray = null;
        ClassPool.doPruning = false;
        try {
            ctClass = this.classPool.get(string);
            for (MockTransformer mockTransformer : this.mockTransformerChain) {
                ctClass = mockTransformer.transform(ctClass);
            }
            byArray = ctClass.toBytecode();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to transform class with name " + string + ". Reason: " + exception.getMessage(), exception);
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    public void setMockTransformerChain(List<MockTransformer> list) {
        this.mockTransformerChain = list;
    }

    @Override
    protected boolean shouldModifyClass(String string) {
        return this.modify.contains(string);
    }

    @Override
    protected boolean shouldLoadUnmodifiedClass(String string) {
        for (String string2 : this.specificClassesToLoadButNotModify) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldLoadModified(String string) {
        for (String string2 : this.packagesToLoadButNotModify) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

