/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.reflect.exceptions.MethodNotFoundException;
import org.powermock.reflect.internal.TypeUtils;
import org.powermock.reflect.internal.WhiteboxImpl;

public class MockGateway {
    public static final Object PROCEED = new Object();
    public static final Object SUPPRESS = new Object();
    public static final String DONT_MOCK_NEXT_CALL = "DontMockNextCall";
    public static boolean MOCK_STANDARD_METHODS = true;
    public static boolean MOCK_GET_CLASS_METHOD = false;

    public static synchronized Object methodCall(Class<?> clazz, String string, Object[] objectArray, Class<?>[] classArray, String string2) throws Throwable {
        return MockGateway.doMethodCall(clazz, string, objectArray, classArray, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object doMethodCall(Object object, String string, Object[] objectArray, Class<?>[] classArray, String string2) throws Throwable, NoSuchMethodException {
        GenericDeclaration genericDeclaration;
        if (!MockGateway.shouldMockMethod(string, classArray)) {
            return PROCEED;
        }
        Object object2 = null;
        MethodInvocationControl methodInvocationControl = null;
        Class<?> clazz = null;
        if (object instanceof Class) {
            clazz = (Class<?>)object;
            methodInvocationControl = MockRepository.getStaticMethodInvocationControl(clazz);
        } else {
            genericDeclaration = object.getClass();
            clazz = WhiteboxImpl.getUnmockedType(genericDeclaration);
            methodInvocationControl = MockRepository.getInstanceMethodInvocationControl(object);
        }
        genericDeclaration = null;
        try {
            genericDeclaration = WhiteboxImpl.getBestMethodCandidate(clazz, string, classArray, true);
        }
        catch (MethodNotFoundException methodNotFoundException) {
            try {
                genericDeclaration = WhiteboxImpl.getMethod(Class.class, string, classArray);
            }
            catch (MethodNotFoundException methodNotFoundException2) {
                throw methodNotFoundException;
            }
        }
        if (methodInvocationControl != null && methodInvocationControl.isMocked((Method)genericDeclaration) && MockGateway.shouldMockThisCall()) {
            object2 = methodInvocationControl.invoke(object, (Method)genericDeclaration, objectArray);
            if (object2 == SUPPRESS) {
                object2 = TypeUtils.getDefaultValue(string2);
            }
        } else if (MockRepository.hasMethodProxy(genericDeclaration)) {
            InvocationHandler invocationHandler = MockRepository.removeMethodProxy(genericDeclaration);
            try {
                object2 = invocationHandler.invoke(object, (Method)genericDeclaration, objectArray);
            }
            finally {
                MockRepository.putMethodProxy(genericDeclaration, invocationHandler);
            }
        } else {
            object2 = MockRepository.shouldSuppressMethod(genericDeclaration) ? TypeUtils.getDefaultValue(string2) : (MockRepository.shouldStubMethod(genericDeclaration) ? MockRepository.getMethodToStub(genericDeclaration) : PROCEED);
        }
        return object2;
    }

    private static boolean shouldMockMethod(String string, Class<?>[] classArray) {
        if (MockGateway.isJavaStandardMethod(string, classArray) && !MOCK_STANDARD_METHODS) {
            return false;
        }
        return !MockGateway.isGetClassMethod(string, classArray) || MOCK_GET_CLASS_METHOD;
    }

    private static boolean isJavaStandardMethod(String string, Class<?>[] classArray) {
        return string.equals("equals") && classArray.length == 1 || string.equals("hashCode") && classArray.length == 0 || string.equals("toString") && classArray.length == 0;
    }

    private static boolean isGetClassMethod(String string, Class<?>[] classArray) {
        return string.equals("getClass") && classArray.length == 0;
    }

    private static boolean shouldMockThisCall() {
        Object t = MockRepository.getAdditionalState(DONT_MOCK_NEXT_CALL);
        boolean bl = t == null;
        MockRepository.removeAdditionalState(DONT_MOCK_NEXT_CALL);
        return bl;
    }

    public static synchronized Object methodCall(Object object, String string, Object[] objectArray, Class<?>[] classArray, String string2) throws Throwable {
        return MockGateway.doMethodCall(object, string, objectArray, classArray, string2);
    }

    public static synchronized Object newInstanceCall(Class<?> clazz, Object[] objectArray, Class<?>[] classArray) throws Throwable {
        NewInvocationControl<?> newInvocationControl = MockRepository.getNewInstanceControl(clazz);
        if (newInvocationControl != null) {
            if (clazz.isMemberClass() && Modifier.isStatic(clazz.getModifiers())) {
                if (objectArray.length > 0 && objectArray[0] == null && classArray.length > 0) {
                    objectArray = MockGateway.copyArgumentsForInnerOrLocalOrAnonymousClass(objectArray);
                }
            } else if ((clazz.isLocalClass() || clazz.isAnonymousClass() || clazz.isMemberClass()) && objectArray.length > 0 && classArray.length > 0 && classArray[0].equals(clazz.getEnclosingClass())) {
                objectArray = MockGateway.copyArgumentsForInnerOrLocalOrAnonymousClass(objectArray);
            }
            return newInvocationControl.invoke(clazz, objectArray, classArray);
        }
        if (MockRepository.shouldSuppressConstructor(WhiteboxImpl.getConstructor(clazz, classArray))) {
            return WhiteboxImpl.getFirstParentConstructor(clazz);
        }
        return PROCEED;
    }

    public static synchronized Object fieldCall(Object object, Class<?> clazz, String string, Class<?> clazz2) {
        if (MockRepository.shouldSuppressField(WhiteboxImpl.getField(clazz, string))) {
            return TypeUtils.getDefaultValue(clazz2);
        }
        return PROCEED;
    }

    public static synchronized Object staticConstructorCall(String string) {
        if (MockRepository.shouldSuppressStaticInitializerFor(string)) {
            return "suppress";
        }
        return PROCEED;
    }

    public static synchronized Object constructorCall(Class<?> clazz, Object[] objectArray, Class<?>[] classArray) throws Throwable {
        Constructor<?> constructor = WhiteboxImpl.getConstructor(clazz, classArray);
        if (MockRepository.shouldSuppressConstructor(constructor)) {
            return null;
        }
        return PROCEED;
    }

    private static Object[] copyArgumentsForInnerOrLocalOrAnonymousClass(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length - 1];
        for (int i = 1; i < objectArray.length; ++i) {
            objectArray2[i - 1] = objectArray[i];
        }
        objectArray = objectArray2;
        return objectArray;
    }
}

