/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.internal.WhiteboxImpl;

public class SuppressCode {
    public static synchronized void suppressConstructor(Constructor<?> ... constructorArray) {
        if (constructorArray == null) {
            throw new IllegalArgumentException("constructors cannot be null.");
        }
        for (Constructor<?> constructor : constructorArray) {
            MockRepository.addConstructorToSuppress(constructor);
            Class<?> clazz = constructor.getDeclaringClass();
            if (clazz == null) continue;
            SuppressCode.suppressConstructor(clazz.getSuperclass());
        }
    }

    public static synchronized void suppressSpecificConstructor(Class<?> clazz, Class<?> ... classArray) {
        MockRepository.addConstructorToSuppress(Whitebox.getConstructor(clazz, classArray));
    }

    public static synchronized void suppressConstructor(Class<?> ... classArray) {
        Class<?>[] classArray2 = classArray;
        int n = classArray2.length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz;
            for (Class<?> clazz2 = clazz = classArray2[i]; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                SuppressCode.suppressConstructor(clazz2, false);
            }
        }
    }

    public static synchronized void suppressConstructor(Class<?> clazz, boolean bl) {
        Constructor<?>[] constructorArray = null;
        constructorArray = bl ? clazz.getConstructors() : clazz.getDeclaredConstructors();
        for (Constructor<?> constructor : constructorArray) {
            MockRepository.addConstructorToSuppress(constructor);
        }
    }

    public static synchronized void suppressField(Field ... fieldArray) {
        for (Field field : fieldArray) {
            MockRepository.addFieldToSuppress(field);
        }
    }

    public static synchronized void suppressField(Class<?>[] classArray) {
        if (classArray == null || classArray.length == 0) {
            throw new IllegalArgumentException("You must supply at least one class.");
        }
        for (Class<?> clazz : classArray) {
            SuppressCode.suppressField(clazz.getDeclaredFields());
        }
    }

    public static synchronized void suppressField(Class<?> clazz, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            SuppressCode.suppressField(new Class[]{clazz});
        } else {
            for (Field field : Whitebox.getFields(clazz, stringArray)) {
                MockRepository.addFieldToSuppress(field);
            }
        }
    }

    public static synchronized void suppressMethod(Method ... methodArray) {
        for (Method method : methodArray) {
            MockRepository.addMethodToSuppress(method);
        }
    }

    public static synchronized void suppressMethod(Class<?> clazz, Class<?> ... classArray) {
        SuppressCode.suppressMethod(clazz, false);
        for (Class<?> clazz2 : classArray) {
            SuppressCode.suppressMethod(clazz2, false);
        }
    }

    public static synchronized void suppressMethod(Class<?>[] classArray) {
        for (Class<?> clazz : classArray) {
            SuppressCode.suppressMethod(clazz, false);
        }
    }

    public static synchronized void suppressMethod(Class<?> clazz, String string, String ... stringArray) {
        for (Method method : Whitebox.getMethods(clazz, string)) {
            MockRepository.addMethodToSuppress(method);
        }
        if (stringArray != null && stringArray.length > 0) {
            for (Method method : Whitebox.getMethods(clazz, stringArray)) {
                MockRepository.addMethodToSuppress(method);
            }
        }
    }

    public static synchronized void suppressMethod(Class<?> clazz, String[] stringArray) {
        for (Method method : Whitebox.getMethods(clazz, stringArray)) {
            MockRepository.addMethodToSuppress(method);
        }
    }

    public static synchronized void suppressMethod(Class<?> clazz, boolean bl) {
        Method[] methodArray = null;
        methodArray = bl ? clazz.getMethods() : clazz.getDeclaredMethods();
        for (Method method : methodArray) {
            MockRepository.addMethodToSuppress(method);
        }
    }

    public static synchronized void suppressMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        Method method = null;
        method = classArray.length > 0 ? Whitebox.getMethod(clazz, string, classArray) : WhiteboxImpl.findMethodOrThrowException(clazz, string, classArray);
        MockRepository.addMethodToSuppress(method);
    }
}

