/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support;

import java.lang.reflect.Method;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.exceptions.MethodNotFoundException;
import org.powermock.reflect.exceptions.TooManyMethodsFoundException;

public class Stubber {
    public static void stubMethod(Method method, Object object) {
        MockRepository.putMethodToStub(method, object);
    }

    public static void stubMethod(Class<?> clazz, String string, Object object) {
        if (clazz == null) {
            throw new IllegalArgumentException("declaringClass cannot be null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("methodName cannot be empty");
        }
        Method[] methodArray = Whitebox.getMethods(clazz, string);
        if (methodArray.length == 0) {
            throw new MethodNotFoundException(String.format("Couldn't find a method with name %s in the class hierarchy of %s", string, clazz.getName()));
        }
        if (methodArray.length > 1) {
            throw new TooManyMethodsFoundException(String.format("Found %d methods with name %s in the class hierarchy of %s.", methodArray.length, string, clazz.getName()));
        }
        MockRepository.putMethodToStub(methodArray[0], object);
    }
}

