/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import java.lang.reflect.Method;
import java.util.List;
import org.mockito.internal.MockHandler;
import org.mockito.internal.MockitoInvocationHandler;
import org.mockito.internal.stubbing.StubberImpl;
import org.powermock.api.mockito.expectation.PowerMockitoStubber;
import org.powermock.api.mockito.expectation.PrivatelyExpectedArguments;
import org.powermock.api.mockito.internal.expectation.DefaultPrivatelyExpectedArguments;
import org.powermock.api.mockito.internal.invocationcontrol.MockitoMethodInvocationControl;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;

public class PowerMockitoStubberImpl
extends StubberImpl
implements PowerMockitoStubber {
    @Override
    public void when(Class<?> clazz) {
        MockitoMethodInvocationControl mockitoMethodInvocationControl = (MockitoMethodInvocationControl)MockRepository.getStaticMethodInvocationControl(clazz);
        this.addAnswersForStubbing(mockitoMethodInvocationControl);
    }

    public <T> T when(T t) {
        Object object;
        MockitoMethodInvocationControl mockitoMethodInvocationControl = (MockitoMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl(t);
        if (mockitoMethodInvocationControl == null) {
            object = super.when(t);
        } else {
            this.addAnswersForStubbing(mockitoMethodInvocationControl);
            object = t;
        }
        return (T)object;
    }

    private void addAnswersForStubbing(MockitoMethodInvocationControl mockitoMethodInvocationControl) {
        MockitoInvocationHandler mockitoInvocationHandler = mockitoMethodInvocationControl.getInvocationHandler().getHandler();
        if (!(mockitoInvocationHandler instanceof MockHandler)) {
            throw new RuntimeException("Cannot perform \"when\" because of unknown mockhandler type " + mockitoInvocationHandler.getClass());
        }
        ((MockHandler)mockitoInvocationHandler).setAnswersForStubbing(Whitebox.getInternalState((Object)this, List.class));
    }

    @Override
    public <T> PrivatelyExpectedArguments when(T t, Method method) throws Exception {
        this.assertNotNull(t, "mock");
        this.assertNotNull(method, "Method");
        this.prepareForStubbing(t);
        return new DefaultPrivatelyExpectedArguments(t, method);
    }

    @Override
    public <T> void when(T t, Object ... objectArray) throws Exception {
        this.assertNotNull(t, "mock");
        this.prepareForStubbing(t);
        Whitebox.invokeMethod(t, objectArray);
    }

    @Override
    public <T> void when(T t, String string, Object ... objectArray) throws Exception {
        this.assertNotNull(t, "mock");
        this.assertNotNull(string, "methodToExpect");
        this.prepareForStubbing(t);
        Whitebox.invokeMethod(t, string, objectArray);
    }

    @Override
    public <T> void when(Class<T> clazz, Object ... objectArray) throws Exception {
        this.assertNotNull(clazz, "classMock");
        this.when((T)clazz);
        Whitebox.invokeMethod(clazz, objectArray);
    }

    @Override
    public <T> void when(Class<T> clazz, String string, Object ... objectArray) throws Exception {
        this.assertNotNull(clazz, "classMock");
        this.assertNotNull(string, "methodToExpect");
        this.when((T)clazz);
        Whitebox.invokeMethod(clazz, string, objectArray);
    }

    @Override
    public <T> PrivatelyExpectedArguments when(Class<T> clazz, Method method) throws Exception {
        this.assertNotNull(clazz, "classMock");
        this.assertNotNull(method, "Method");
        this.when((T)clazz);
        return new DefaultPrivatelyExpectedArguments(clazz, method);
    }

    private void assertNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string + " cannot be null");
        }
    }

    private <T> void prepareForStubbing(T t) {
        MockitoMethodInvocationControl mockitoMethodInvocationControl = (MockitoMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl(t);
        this.addAnswersForStubbing(mockitoMethodInvocationControl);
    }
}

