/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.configuration;

import java.lang.reflect.Field;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.SpyAnnotationEngine;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.reflect.Whitebox;

public class PowerMockitoSpyAnnotationEngine
extends SpyAnnotationEngine {
    public void process(Class<?> clazz, Object object) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Spy.class)) continue;
            try {
                Whitebox.invokeMethod((Object)this, Spy.class, field, new Class[]{Mock.class, MockitoAnnotations.Mock.class, Captor.class});
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            boolean bl = field.isAccessible();
            field.setAccessible(true);
            try {
                Object object2 = field.get(object);
                if (object2 == null) {
                    throw new MockitoException("Cannot create a @Spy for '" + field.getName() + "' field because the *instance* is missing\n" + "Example of correct usage of @Spy:\n" + "   @Spy List mock = new LinkedList();\n");
                }
                field.set(object, PowerMockito.spy(object2));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MockitoException("Problems initiating spied field " + field.getName(), (Throwable)illegalAccessException);
            }
            finally {
                field.setAccessible(bl);
            }
        }
    }
}

