/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.mockito.Captor;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.configuration.DefaultAnnotationEngine;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.api.mockito.internal.configuration.PowerMockitoInjectingAnnotationEngine;
import org.powermock.core.classloader.annotations.Mock;
import org.powermock.core.spi.listener.AnnotationEnablerListener;
import org.powermock.core.spi.support.AbstractPowerMockTestListenerBase;
import org.powermock.reflect.Whitebox;

public class AnnotationEnabler
extends AbstractPowerMockTestListenerBase
implements AnnotationEnablerListener {
    @Override
    public void beforeTestMethod(Object object, Method method, Object[] objectArray) throws Exception {
        this.standardInject(object);
        this.injectSpiesAndInjectToSetters(object);
        this.injectCaptor(object);
    }

    private void injectSpiesAndInjectToSetters(Object object) {
        new PowerMockitoInjectingAnnotationEngine().process(object.getClass(), object);
    }

    private void injectCaptor(Object object) throws Exception {
        Set<Field> set = Whitebox.getFieldsAnnotatedWith(object, Captor.class, new Class[0]);
        for (Field field : set) {
            Object t = Whitebox.invokeMethod((Object)new DefaultAnnotationEngine(), "processAnnotationOn", field.getAnnotation(Captor.class), field);
            field.set(object, t);
        }
    }

    private void standardInject(Object object) throws IllegalAccessException {
        Set<Field> set = Whitebox.getFieldsAnnotatedWith(object, this.getMockAnnotations());
        for (Field field : set) {
            Mock mock;
            String[] stringArray;
            if (field.get(object) != null) continue;
            Class<?> clazz = field.getType();
            if (field.isAnnotationPresent(Mock.class) && ((stringArray = (mock = field.getAnnotation(Mock.class)).value()).length != 1 || !"".equals(stringArray[0]))) {
                System.err.println("PowerMockito deprecation: Use PowerMockito.spy(..) for partial mocking instead. A standard mock will be created instead.");
            }
            field.set(object, PowerMockito.mock(clazz));
        }
    }

    @Override
    public Class<? extends Annotation>[] getMockAnnotations() {
        return new Class[]{org.mockito.Mock.class, MockitoAnnotations.Mock.class, Mock.class};
    }
}

