/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.verification.VerificationMode;

public class VerificationWithTimeoutImpl {
    VerificationMode delegate;
    int timeout;
    int treshhold;

    public VerificationWithTimeoutImpl(int n, int n2, VerificationMode verificationMode) {
        this.treshhold = n;
        this.timeout = n2;
        this.delegate = verificationMode;
    }

    public void verify(VerificationData verificationData) {
        MockitoAssertionError mockitoAssertionError = null;
        for (int i = 0; i <= this.timeout; i += this.treshhold) {
            try {
                this.delegate.verify(verificationData);
                return;
            }
            catch (MockitoAssertionError mockitoAssertionError2) {
                mockitoAssertionError = mockitoAssertionError2;
                this.sleep(this.treshhold);
                continue;
            }
        }
        if (mockitoAssertionError != null) {
            throw mockitoAssertionError;
        }
    }

    void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public VerificationMode getDelegate() {
        return this.delegate;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTreshhold() {
        return this.treshhold;
    }
}

