/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.internal.verification.api.VerificationDataInOrder;
import org.mockito.internal.verification.api.VerificationInOrderMode;
import org.mockito.verification.VerificationMode;

public class NoMoreInteractions
implements VerificationMode,
VerificationInOrderMode {
    @Override
    public void verify(VerificationData verificationData) {
        Invocation invocation = new InvocationsFinder().findFirstUnverified(verificationData.getAllInvocations());
        if (invocation != null) {
            new Reporter().noMoreInteractionsWanted(invocation, verificationData.getAllInvocations());
        }
    }

    @Override
    public void verifyInOrder(VerificationDataInOrder verificationDataInOrder) {
        List<Invocation> list = verificationDataInOrder.getAllInvocations();
        Invocation invocation = new InvocationsFinder().findFirstUnverifiedInOrder(verificationDataInOrder.getOrderingContext(), list);
        if (invocation != null) {
            new Reporter().noMoreInteractionsWantedInOrder(invocation);
        }
    }
}

