/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.internal.verification.api.VerificationDataInOrder;
import org.mockito.internal.verification.api.VerificationInOrderMode;
import org.mockito.internal.verification.checkers.AtLeastXNumberOfInvocationsChecker;
import org.mockito.internal.verification.checkers.AtLeastXNumberOfInvocationsInOrderChecker;
import org.mockito.internal.verification.checkers.MissingInvocationChecker;
import org.mockito.internal.verification.checkers.MissingInvocationInOrderChecker;
import org.mockito.verification.VerificationMode;

public class AtLeast
implements VerificationInOrderMode,
VerificationMode {
    final int wantedCount;

    public AtLeast(int n) {
        if (n < 0) {
            throw new MockitoException("Negative value is not allowed here");
        }
        this.wantedCount = n;
    }

    @Override
    public void verify(VerificationData verificationData) {
        MissingInvocationChecker missingInvocationChecker = new MissingInvocationChecker();
        AtLeastXNumberOfInvocationsChecker atLeastXNumberOfInvocationsChecker = new AtLeastXNumberOfInvocationsChecker();
        if (this.wantedCount == 1) {
            missingInvocationChecker.check(verificationData.getAllInvocations(), verificationData.getWanted());
        }
        atLeastXNumberOfInvocationsChecker.check(verificationData.getAllInvocations(), verificationData.getWanted(), this.wantedCount);
    }

    @Override
    public void verifyInOrder(VerificationDataInOrder verificationDataInOrder) {
        List<Invocation> list = verificationDataInOrder.getAllInvocations();
        InvocationMatcher invocationMatcher = verificationDataInOrder.getWanted();
        MissingInvocationInOrderChecker missingInvocationInOrderChecker = new MissingInvocationInOrderChecker();
        AtLeastXNumberOfInvocationsInOrderChecker atLeastXNumberOfInvocationsInOrderChecker = new AtLeastXNumberOfInvocationsInOrderChecker(verificationDataInOrder.getOrderingContext());
        if (this.wantedCount == 1) {
            missingInvocationInOrderChecker.check(list, invocationMatcher, this, verificationDataInOrder.getOrderingContext());
        }
        atLeastXNumberOfInvocationsInOrderChecker.check(list, invocationMatcher, this.wantedCount);
    }

    public String toString() {
        return "Wanted invocations count: at least " + this.wantedCount;
    }
}

