/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Field;

public class Whitebox {
    public static Object getInternalState(Object object, String string) {
        Class<?> clazz = object.getClass();
        try {
            Field field = Whitebox.getFieldFromHierarchy(clazz, string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to set internal state on a private field. Please report to mockito mailing list.", exception);
        }
    }

    public static void setInternalState(Object object, String string, Object object2) {
        Class<?> clazz = object.getClass();
        try {
            Field field = Whitebox.getFieldFromHierarchy(clazz, string);
            field.setAccessible(true);
            field.set(object, object2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to set internal state on a private field. Please report to mockito mailing list.", exception);
        }
    }

    private static Field getFieldFromHierarchy(Class<?> clazz, String string) {
        Field field = Whitebox.getField(clazz, string);
        while (field == null && clazz != Object.class) {
            clazz = clazz.getSuperclass();
            field = Whitebox.getField(clazz, string);
        }
        if (field == null) {
            throw new RuntimeException("You want me to set value to this field: '" + string + "' on this class: '" + clazz.getSimpleName() + "' but this field is not declared withing hierarchy of this class!");
        }
        return field;
    }

    private static Field getField(Class<?> clazz, String string) {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }
}

