/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import org.mockito.internal.util.reflection.AccessibilityChanger;

public class FieldSetter {
    private final Object target;
    private final Field field;

    public FieldSetter(Object object, Field field) {
        this.target = object;
        this.field = field;
    }

    public void set(Object object) {
        AccessibilityChanger accessibilityChanger = new AccessibilityChanger();
        accessibilityChanger.enableAccess(this.field);
        try {
            this.field.set(this.target, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Access not authorized on field '" + this.field + "' of object '" + this.target + "' with value: '" + object + "'", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("Wrong argument on field '" + this.field + "' of object '" + this.target + "' with value: '" + object + "', \n" + "reason : " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
        accessibilityChanger.safelyDisableAccess(this.field);
    }
}

