/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mockito.internal.util.reflection.AccessibilityChanger;

public class BeanPropertySetter {
    private final Object target;
    private boolean reportNoSetterFound;
    private final Field field;

    public BeanPropertySetter(Object object, Field field, boolean bl) {
        this.field = field;
        this.target = object;
        this.reportNoSetterFound = bl;
    }

    public BeanPropertySetter(Object object, Field field) {
        this(object, field, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean set(Object object) {
        AccessibilityChanger accessibilityChanger = new AccessibilityChanger();
        Method method = null;
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            BeanInfo beanInfo = Introspector.getBeanInfo(this.target.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                if (!this.propertyNameMatchFieldName(propertyDescriptor) || !this.propertyTypeMatchFieldType(propertyDescriptor) || (method = propertyDescriptor.getWriteMethod()) == null) continue;
                accessibilityChanger.enableAccess(method);
                method.invoke(this.target, object);
                boolean bl = true;
                if (method != null) {
                    accessibilityChanger.safelyDisableAccess(method);
                }
                return bl;
            }
            if (method != null) {
                accessibilityChanger.safelyDisableAccess(method);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                throw new RuntimeException("Setter '" + method + "' of '" + this.target + "' with value '" + object + "' threw exception : '" + invocationTargetException.getTargetException() + "'", invocationTargetException);
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Access not authorized on field '" + this.field + "' of object '" + this.target + "' with value: '" + object + "'", illegalAccessException);
                }
                catch (IntrospectionException introspectionException) {
                    throw new RuntimeException("Something went wrong when trying to infer by introspection the setter of property '" + this.field.getName() + "' on type '" + this.target.getClass() + "'" + this.target.getClass(), introspectionException);
                }
            }
            catch (Throwable throwable) {
                if (method != null) {
                    accessibilityChanger.safelyDisableAccess(method);
                }
                throw throwable;
            }
        }
        this.reportNoSetterFound();
        return false;
    }

    private void reportNoSetterFound() {
        if (this.reportNoSetterFound) {
            throw new RuntimeException("Problems setting value on object: [" + this.target + "] for property : [" + this.field.getName() + "], setter not found");
        }
    }

    private boolean propertyTypeMatchFieldType(PropertyDescriptor propertyDescriptor) {
        return this.field.getType().equals(propertyDescriptor.getPropertyType());
    }

    private boolean propertyNameMatchFieldName(PropertyDescriptor propertyDescriptor) {
        return this.field.getName().equals(propertyDescriptor.getName());
    }
}

