/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.lang.reflect.Array;

public class Equality {
    public static boolean areEqual(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == null && object2 == null;
        }
        if (Equality.isArray(object)) {
            return Equality.isArray(object2) && Equality.areArraysEqual(object, object2);
        }
        return object.equals(object2);
    }

    static boolean areArraysEqual(Object object, Object object2) {
        return Equality.areArrayLengthsEqual(object, object2) && Equality.areArrayElementsEqual(object, object2);
    }

    static boolean areArrayLengthsEqual(Object object, Object object2) {
        return Array.getLength(object) == Array.getLength(object2);
    }

    static boolean areArrayElementsEqual(Object object, Object object2) {
        for (int i = 0; i < Array.getLength(object); ++i) {
            if (Equality.areEqual(Array.get(object, i), Array.get(object2, i))) continue;
            return false;
        }
        return true;
    }

    static boolean isArray(Object object) {
        return object.getClass().isArray();
    }
}

