/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.hamcrest.Description;
import org.mockito.internal.matchers.Equals;

public class ArrayEquals
extends Equals {
    private static final long serialVersionUID = -7167812844261087583L;

    public ArrayEquals(Object object) {
        super(object);
    }

    @Override
    public boolean matches(Object object) {
        Object object2 = this.getWanted();
        if (object2 == null || object == null) {
            return super.matches(object);
        }
        if (object2 instanceof boolean[] && object instanceof boolean[]) {
            return Arrays.equals((boolean[])object2, (boolean[])object);
        }
        if (object2 instanceof byte[] && object instanceof byte[]) {
            return Arrays.equals((byte[])object2, (byte[])object);
        }
        if (object2 instanceof char[] && object instanceof char[]) {
            return Arrays.equals((char[])object2, (char[])object);
        }
        if (object2 instanceof double[] && object instanceof double[]) {
            return Arrays.equals((double[])object2, (double[])object);
        }
        if (object2 instanceof float[] && object instanceof float[]) {
            return Arrays.equals((float[])object2, (float[])object);
        }
        if (object2 instanceof int[] && object instanceof int[]) {
            return Arrays.equals((int[])object2, (int[])object);
        }
        if (object2 instanceof long[] && object instanceof long[]) {
            return Arrays.equals((long[])object2, (long[])object);
        }
        if (object2 instanceof short[] && object instanceof short[]) {
            return Arrays.equals((short[])object2, (short[])object);
        }
        if (object2 instanceof Object[] && object instanceof Object[]) {
            return Arrays.equals((Object[])object2, (Object[])object);
        }
        return false;
    }

    @Override
    public void describeTo(Description description) {
        if (this.getWanted() != null && this.getWanted().getClass().isArray()) {
            this.appendArray(ArrayEquals.createObjectArray(this.getWanted()), description);
        } else {
            super.describeTo(description);
        }
    }

    private void appendArray(Object[] objectArray, Description description) {
        description.appendText("[");
        for (int i = 0; i < objectArray.length; ++i) {
            new Equals(objectArray[i]).describeTo(description);
            if (i == objectArray.length - 1) continue;
            description.appendText(", ");
        }
        description.appendText("]");
    }

    public static Object[] createObjectArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        Object[] objectArray = new Object[Array.getLength(object)];
        for (int i = 0; i < Array.getLength(object); ++i) {
            objectArray[i] = Array.get(object, i);
        }
        return objectArray;
    }
}

