/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.listeners;

import org.mockito.exceptions.PrintableInvocation;
import org.mockito.internal.invocation.Invocation;
import org.mockito.listeners.MethodInvocationReport;

public class NotifiedMethodInvocationReport
implements MethodInvocationReport {
    private final Invocation invocation;
    private Object returnedValue;
    private Throwable throwable;

    public NotifiedMethodInvocationReport(Invocation invocation, Object object) {
        this.invocation = invocation;
        this.returnedValue = object;
    }

    public NotifiedMethodInvocationReport(Invocation invocation, Throwable throwable) {
        this.invocation = invocation;
        this.throwable = throwable;
    }

    @Override
    public PrintableInvocation getInvocation() {
        return this.invocation;
    }

    @Override
    public Object getReturnedValue() {
        return this.returnedValue;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public boolean threwException() {
        return this.throwable != null;
    }

    @Override
    public String getLocationOfStubbing() {
        return this.invocation.stubInfo() == null ? null : this.invocation.stubInfo().stubbedAt();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NotifiedMethodInvocationReport notifiedMethodInvocationReport = (NotifiedMethodInvocationReport)object;
        if (this.invocation != null ? !this.invocation.equals(notifiedMethodInvocationReport.invocation) : notifiedMethodInvocationReport.invocation != null) {
            return false;
        }
        if (this.returnedValue != null ? !this.returnedValue.equals(notifiedMethodInvocationReport.returnedValue) : notifiedMethodInvocationReport.returnedValue != null) {
            return false;
        }
        return !(this.throwable != null ? !this.throwable.equals(notifiedMethodInvocationReport.throwable) : notifiedMethodInvocationReport.throwable != null);
    }

    public int hashCode() {
        int n = this.invocation != null ? this.invocation.hashCode() : 0;
        n = 31 * n + (this.returnedValue != null ? this.returnedValue.hashCode() : 0);
        n = 31 * n + (this.throwable != null ? this.throwable.hashCode() : 0);
        return n;
    }
}

