/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.exceptions.PrintableInvocation;
import org.mockito.internal.debugging.Location;
import org.mockito.internal.invocation.ArgumentsComparator;
import org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.matchers.CapturesArguments;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.internal.reporting.PrintingFriendlyInvocation;

public class InvocationMatcher
implements PrintableInvocation,
PrintingFriendlyInvocation,
CapturesArgumensFromInvocation,
Serializable {
    private static final long serialVersionUID = -3047126096857467610L;
    private final Invocation invocation;
    private final List<Matcher> matchers;

    public InvocationMatcher(Invocation invocation, List<Matcher> list) {
        this.invocation = invocation;
        this.matchers = list.isEmpty() ? invocation.argumentsToMatchers() : list;
    }

    public InvocationMatcher(Invocation invocation) {
        this(invocation, Collections.emptyList());
    }

    public Method getMethod() {
        return this.invocation.getMethod();
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public List<Matcher> getMatchers() {
        return this.matchers;
    }

    @Override
    public String toString() {
        return this.invocation.toString(this.matchers, new PrintSettings());
    }

    public boolean matches(Invocation invocation) {
        return this.invocation.getMock().equals(invocation.getMock()) && this.hasSameMethod(invocation) && new ArgumentsComparator().argumentsMatch(this, invocation);
    }

    private boolean safelyArgumentsMatch(Object[] objectArray) {
        try {
            return new ArgumentsComparator().argumentsMatch(this, objectArray);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean hasSimilarMethod(Invocation invocation) {
        String string = this.getMethod().getName();
        String string2 = invocation.getMethod().getName();
        boolean bl = string.equals(string2);
        boolean bl2 = !invocation.isVerified();
        boolean bl3 = this.getInvocation().getMock() == invocation.getMock();
        boolean bl4 = this.hasSameMethod(invocation);
        if (!(bl && bl2 && bl3)) {
            return false;
        }
        boolean bl5 = !bl4 && this.safelyArgumentsMatch(invocation.getArguments());
        return !bl5;
    }

    public boolean hasSameMethod(Invocation invocation) {
        Class<?>[] classArray;
        Class<?>[] classArray2;
        Method method = this.invocation.getMethod();
        Method method2 = invocation.getMethod();
        if (method.getName() != null && method.getName().equals(method2.getName()) && (classArray2 = method.getParameterTypes()).length == (classArray = method2.getParameterTypes()).length) {
            for (int i = 0; i < classArray2.length; ++i) {
                if (classArray2[i] == classArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Location getLocation() {
        return this.invocation.getLocation();
    }

    @Override
    public String toString(PrintSettings printSettings) {
        return this.invocation.toString(this.matchers, printSettings);
    }

    @Override
    public void captureArgumentsFrom(Invocation invocation) {
        int n = 0;
        for (Matcher matcher : this.matchers) {
            if (matcher instanceof CapturesArguments && invocation.getArguments().length > n) {
                ((CapturesArguments)matcher).captureFrom(invocation.getArguments()[n]);
            }
            ++n;
        }
    }

    public static List<InvocationMatcher> createFrom(List<Invocation> list) {
        LinkedList<InvocationMatcher> linkedList = new LinkedList<InvocationMatcher>();
        for (Invocation invocation : list) {
            linkedList.add(new InvocationMatcher(invocation));
        }
        return linkedList;
    }
}

