/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation;

import java.util.ArrayList;
import java.util.List;
import org.mockito.MockSettings;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.debugging.VerboseMockInvocationLogger;
import org.mockito.internal.util.MockName;
import org.mockito.listeners.InvocationListener;
import org.mockito.stubbing.Answer;

public class MockSettingsImpl
implements MockSettings {
    private static final long serialVersionUID = 4475297236197939568L;
    private Class<?>[] extraInterfaces;
    private String name;
    private Object spiedInstance;
    private Answer<Object> defaultAnswer;
    private MockName mockName;
    private boolean serializable;
    private List<InvocationListener> invocationListeners = new ArrayList<InvocationListener>();

    @Override
    public MockSettings serializable() {
        this.serializable = true;
        return this;
    }

    @Override
    public MockSettings extraInterfaces(Class<?> ... classArray) {
        if (classArray == null || classArray.length == 0) {
            new Reporter().extraInterfacesRequiresAtLeastOneInterface();
        }
        for (Class<?> clazz : classArray) {
            if (clazz == null) {
                new Reporter().extraInterfacesDoesNotAcceptNullParameters();
                continue;
            }
            if (clazz.isInterface()) continue;
            new Reporter().extraInterfacesAcceptsOnlyInterfaces(clazz);
        }
        this.extraInterfaces = classArray;
        return this;
    }

    public MockName getMockName() {
        return this.mockName;
    }

    public Class<?>[] getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public Object getSpiedInstance() {
        return this.spiedInstance;
    }

    @Override
    public MockSettings name(String string) {
        this.name = string;
        return this;
    }

    @Override
    public MockSettings spiedInstance(Object object) {
        this.spiedInstance = object;
        return this;
    }

    @Override
    public MockSettings defaultAnswer(Answer answer) {
        this.defaultAnswer = answer;
        return this;
    }

    public Answer<Object> getDefaultAnswer() {
        return this.defaultAnswer;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public void initiateMockName(Class clazz) {
        this.mockName = new MockName(this.name, clazz);
    }

    @Override
    public MockSettings verboseLogging() {
        if (!this.invocationListenersContainsType(VerboseMockInvocationLogger.class)) {
            this.invocationListeners(new VerboseMockInvocationLogger());
        }
        return this;
    }

    @Override
    public MockSettings invocationListeners(InvocationListener ... invocationListenerArray) {
        if (invocationListenerArray == null || invocationListenerArray.length == 0) {
            new Reporter().invocationListenersRequiresAtLeastOneListener();
        }
        for (InvocationListener invocationListener : invocationListenerArray) {
            if (invocationListener == null) {
                new Reporter().invocationListenerDoesNotAcceptNullParameters();
            }
            this.invocationListeners.add(invocationListener);
        }
        return this;
    }

    private boolean invocationListenersContainsType(Class<?> clazz) {
        for (InvocationListener invocationListener : this.invocationListeners) {
            if (!invocationListener.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public List<InvocationListener> getInvocationListeners() {
        return this.invocationListeners;
    }

    public boolean containsInvocationListener(InvocationListener invocationListener) {
        return this.invocationListeners.contains(invocationListener);
    }

    public boolean hasInvocationListeners() {
        return !this.invocationListeners.isEmpty();
    }
}

