/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.proxy;

import java.util.List;
import org.mockito.asm.Type;
import org.mockito.cglib.core.ClassEmitter;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.MethodInfo;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.core.TypeUtils;
import org.mockito.cglib.proxy.CallbackGenerator;

class FixedValueGenerator
implements CallbackGenerator {
    public static final FixedValueGenerator INSTANCE = new FixedValueGenerator();
    private static final Type FIXED_VALUE = TypeUtils.parseType("org.mockito.cglib.proxy.FixedValue");
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");

    FixedValueGenerator() {
    }

    @Override
    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context, List list) {
        for (MethodInfo methodInfo : list) {
            CodeEmitter codeEmitter = context.beginMethod(classEmitter, methodInfo);
            context.emitCallback(codeEmitter, context.getIndex(methodInfo));
            codeEmitter.invoke_interface(FIXED_VALUE, LOAD_OBJECT);
            codeEmitter.unbox_or_zero(codeEmitter.getReturnType());
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
    }

    @Override
    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context, List list) {
    }
}

