/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.core;

import org.mockito.asm.Label;
import org.mockito.asm.MethodAdapter;
import org.mockito.asm.MethodVisitor;
import org.mockito.asm.Type;

public class LocalVariablesSorter
extends MethodAdapter {
    protected final int firstLocal;
    private final State state;

    public LocalVariablesSorter(int n, String string, MethodVisitor methodVisitor) {
        super(methodVisitor);
        this.state = new State();
        Type[] typeArray = Type.getArgumentTypes(string);
        this.state.nextLocal = (8 & n) != 0 ? 0 : 1;
        for (int i = 0; i < typeArray.length; ++i) {
            this.state.nextLocal += typeArray[i].getSize();
        }
        this.firstLocal = this.state.nextLocal;
    }

    public LocalVariablesSorter(LocalVariablesSorter localVariablesSorter) {
        super(localVariablesSorter.mv);
        this.state = localVariablesSorter.state;
        this.firstLocal = localVariablesSorter.firstLocal;
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        int n3;
        switch (n) {
            case 22: 
            case 24: 
            case 55: 
            case 57: {
                n3 = 2;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        this.mv.visitVarInsn(n, this.remap(n2, n3));
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.mv.visitIincInsn(this.remap(n, 1), n2);
    }

    @Override
    public void visitMaxs(int n, int n2) {
        this.mv.visitMaxs(n, this.state.nextLocal);
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.mv.visitLocalVariable(string, string2, string3, label, label2, this.remap(n));
    }

    protected int newLocal(int n) {
        int n2 = this.state.nextLocal;
        this.state.nextLocal += n;
        return n2;
    }

    private int remap(int n, int n2) {
        int n3;
        if (n < this.firstLocal) {
            return n;
        }
        int n4 = 2 * n + n2 - 1;
        int n5 = this.state.mapping.length;
        if (n4 >= n5) {
            int[] nArray = new int[Math.max(2 * n5, n4 + 1)];
            System.arraycopy(this.state.mapping, 0, nArray, 0, n5);
            this.state.mapping = nArray;
        }
        if ((n3 = this.state.mapping[n4]) == 0) {
            this.state.mapping[n4] = n3 = this.state.nextLocal + 1;
            this.state.nextLocal += n2;
        }
        return n3 - 1;
    }

    private int remap(int n) {
        int n2;
        if (n < this.firstLocal) {
            return n;
        }
        int n3 = 2 * n;
        int n4 = n2 = n3 < this.state.mapping.length ? this.state.mapping[n3] : 0;
        if (n2 == 0) {
            int n5 = n2 = n3 + 1 < this.state.mapping.length ? this.state.mapping[n3 + 1] : 0;
        }
        if (n2 == 0) {
            throw new IllegalStateException("Unknown local variable " + n);
        }
        return n2 - 1;
    }

    private static class State {
        int[] mapping = new int[40];
        int nextLocal;

        private State() {
        }
    }
}

