#
#  Copyright (C) 2021 Intel Corporation
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

# Get include and lib paths for LIBGCSS from pkgconfig
include(FindPackageHandleStandardArgs)

if((NOT DEFINED IPU_VER) OR (${IPU_VER} STREQUAL ipu6))
set(LIBGCSS_PKG_SUFFIX "")
else()
set(LIBGCSS_PKG_SUFFIX "-${IPU_VER}")
endif()

find_package(PkgConfig)
pkg_check_modules(LIBGCSS libgcss${LIBGCSS_PKG_SUFFIX})
if(NOT LIBGCSS_FOUND)
    message(FATAL_ERROR "LIBGCSS not found")
endif()

set(CMAKE_LIBRARY_PATH ${CMAKE_LIBRARY_PATH} ${LIBGCSS_LIBRARY_DIRS})

# Libraries
find_library(GCSS_LIB gcss${LIBGCSS_PKG_SUFFIX})
set(LIBGCSS_LIBS ${GCSS_LIB})

# handle the QUIETLY and REQUIRED arguments and set EXPAT_FOUND to TRUE if
# all listed variables are TRUE
find_package_handle_standard_args(LIBGCSS REQUIRED_VARS LIBGCSS_INCLUDE_DIRS LIBGCSS_LIBS)

if(NOT LIBGCSS_FOUND)
        message(FATAL_ERROR "LIBGCSS not found")
endif()

