#ifndef __HRN_SIDEBAR_ITEM_H__
#define __HRN_SIDEBAR_ITEM_H__

#include <nbtk/nbtk.h>

#include "hrn-pin-manager.h"
#include "hrn-source.h"

G_BEGIN_DECLS

#define HRN_TYPE_SIDEBAR_ITEM                                           \
   (hrn_sidebar_item_get_type())
#define HRN_SIDEBAR_ITEM(obj)                                           \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_SIDEBAR_ITEM,                  \
                                HrnSidebarItem))
#define HRN_SIDEBAR_ITEM_CLASS(klass)                                   \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_SIDEBAR_ITEM,                     \
                             HrnSidebarItemClass))
#define IS_HRN_SIDEBAR_ITEM(obj)                                        \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_SIDEBAR_ITEM))
#define IS_HRN_SIDEBAR_ITEM_CLASS(klass)                                \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_SIDEBAR_ITEM))
#define HRN_SIDEBAR_ITEM_GET_CLASS(obj)                                 \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_SIDEBAR_ITEM,                   \
                               HrnSidebarItemClass))

typedef struct _HrnSidebarItemPrivate HrnSidebarItemPrivate;
typedef struct _HrnSidebarItem      HrnSidebarItem;
typedef struct _HrnSidebarItemClass HrnSidebarItemClass;

struct _HrnSidebarItem
{
    NbtkTable parent;

    HrnSidebarItemPrivate *priv;
};

struct _HrnSidebarItemClass
{
    NbtkTableClass parent_class;
};

GType hrn_sidebar_item_get_type (void) G_GNUC_CONST;
HrnSidebarItem *hrn_sidebar_item_new (const char    *name,
                                      HrnSource     *source,
                                      HrnPinManager *pin_manager);
void hrn_sidebar_item_set_selected (HrnSidebarItem *item,
                                   gboolean        selected);
void hrn_sidebar_item_select_initial (HrnSidebarItem *item);


G_END_DECLS

#endif /* __HRN_SIDEBAR_ITEM_H__ */
