#include <glib.h>
#include <glib/gi18n.h>

#include "hrn-cluster-node.h"
#include "hrn-image-tile.h"
#include "hrn-tileable.h"

enum {
    PROP_0,
    PROP_NODE
};

struct _HrnImageTilePrivate {
    HrnClusterNode *node;
    guint32 visibility_id;
};

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_IMAGE_TILE, HrnImageTilePrivate))
G_DEFINE_TYPE (HrnImageTile, hrn_image_tile, HRN_TYPE_TILE);

static void
hrn_image_tile_finalize (GObject *object)
{
    HrnImageTile *tile = (HrnImageTile *) object;
    HrnImageTilePrivate *priv = tile->priv;

    if (priv->visibility_id) {
        g_signal_handler_disconnect (priv->node, priv->visibility_id);
        priv->visibility_id = 0;
    }

    G_OBJECT_CLASS (hrn_image_tile_parent_class)->finalize (object);
}

static void
hrn_image_tile_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_image_tile_parent_class)->dispose (object);
}

static void
node_visibility_changed (HrnClusterNode *node,
                         gboolean        hidden,
                         HrnImageTile   *tile)
{
    g_print ("[image] %s %s\n", node->name, hidden ? "hidden" : "shown");
    hrn_tileable_visibility_changed ((HrnTileable *) tile, hidden);
}

static void
hrn_image_tile_set_property (GObject      *object,
                             guint         prop_id,
                             const GValue *value,
                             GParamSpec   *pspec)
{
    HrnImageTile *self = (HrnImageTile *) object;
    HrnImageTilePrivate *priv = self->priv;
    PictureCluster *picture_cluster;

    switch (prop_id) {
    case PROP_NODE:
        priv->node = g_value_get_pointer (value);
        priv->visibility_id = g_signal_connect
            (priv->node, "visibility-changed",
             G_CALLBACK (node_visibility_changed), self);
        clutter_actor_set_name ((ClutterActor *) self, priv->node->name);

        picture_cluster = (PictureCluster *) priv->node->data;
        g_object_set (self,
                      "item", picture_cluster->item,
                      NULL);
        break;

    default:
        break;
    }
}

static void
hrn_image_tile_get_property (GObject    *object,
                             guint       prop_id,
                             GValue     *value,
                             GParamSpec *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static HrnClusterNode *
hrn_image_tile_get_node (HrnTile *tile)
{
    HrnImageTile *image = (HrnImageTile *) tile;
    HrnImageTilePrivate *priv = image->priv;

    return priv->node;
}

static const char *
hrn_image_tile_get_label (HrnTile *tile)
{
    return _("Display Picture");
}

static void
hrn_image_tile_class_init (HrnImageTileClass *klass)
{
    GObjectClass *o_class = (GObjectClass *) klass;
    HrnTileClass *t_class = (HrnTileClass *) klass;

    o_class->dispose = hrn_image_tile_dispose;
    o_class->finalize = hrn_image_tile_finalize;
    o_class->set_property = hrn_image_tile_set_property;
    o_class->get_property = hrn_image_tile_get_property;

    t_class->get_node = hrn_image_tile_get_node;
    t_class->get_label = hrn_image_tile_get_label;

    g_type_class_add_private (klass, sizeof (HrnImageTilePrivate));

    g_object_class_override_property (o_class, PROP_NODE, "node");
}

static void
hrn_image_tile_init (HrnImageTile *self)
{
    HrnImageTilePrivate *priv = GET_PRIVATE (self);
    self->priv = priv;
}

