#include <stdlib.h>
#include <stdio.h>
#include <linux/input.h>

int main(int argc, char *argv[])
{
	char *filename;
	FILE *file;
	struct input_event ev;
	int n = 0;

	if (argc != 2) {
		fprintf(stderr, "Usage: f2 <event stream>\n");
		exit(1);
	}
	filename = argv[1];
	
	file = fopen(filename, "r");
	if (!file) {
		fprintf(stderr, "f2: %s: open failed\n", filename);
		exit(1);
	}

	while (fread(&ev, sizeof(ev), 1, file)) {
		if (ev.type == EV_KEY && ev.code == KEY_WLAN && ev.value) {
			printf("f2 %d\n", ++n);
			fflush(stdout);
		}
	}
		
	fclose(file);

	exit(0);
}
