/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ENMUtil.h"
#include "wlan.h"
#include <stdlib.h>
#include "wlanacmevent.h"

#include "WlanScanner.h"
#include "DataCenter.h"

wxString MacAddressToString(const unsigned char* mac)
{
	int a[6];
	for (int i = 0 ; i < WLAN_MAC_ADDRESS_LENGTH ; i ++)
	{
		a[i] = 0 + mac[i];
	}
	return wxString::Format(_T("%02X:%02X:%02X:%02X:%02X:%02X"), a[0], a[1], a[2], a[3], a[4], a[5]);
}

bool StringToMacAddress(unsigned char* mac, const char* str, size_t strLen)
{
    if (str == NULL || mac == NULL || strLen < 17)
        return false;

    const char* colon = ":";
    size_t index = 0;
    const char* first = str;
    const char* second = NULL;
    while (index < 6)
    {
        second = strstr(first, colon);
        unsigned char hex = 0;
        const char* p = first;
        int count = 0;
        while (count < 2)
        {
            char n = *p - '0';
            if (n > 9) n -= 7;
            hex = hex * 16 + n;
            p++;
            count++;
        }
        mac[index] = hex;
        index++;
        if (second != NULL)
        {
            first = strstr(second, colon);
            first++;
        }
    }
    return true;
}

bool operator == (const WlanSsid& ssid1, const WlanSsid& ssid2)
{
    bool result = true;
    result &= (ssid1.length == ssid2.length);
    for (int i = 0 ; i < AP_SSID_MAX_LENGTH ; i ++)
    {
        result &= (ssid1.ucSsid[i] == ssid2.ucSsid[i]);
    }
    return result;
}

bool operator != (const WlanSsid& ssid1, const WlanSsid& ssid2)
{
    return !(ssid1 == ssid2);
}

int CompareMacAddress(unsigned char* mac1, unsigned char* mac2)
{
    if ( mac1 == NULL || mac2 == NULL )
        return 0;

    int differ = 0;
    int index = 0;
    do
    {
        differ = mac1[index] - mac2[index];
        index++;
    }
    while ( differ == 0 && index < WLAN_MAC_ADDRESS_LENGTH );
    return differ;
}


