/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "PublishThread.h"
#if defined(__UNIX__)
#include "Avahi.h"
#endif
#include "ENMUtil.h"

static wxString dcLogFilePublishThread(_T("C:\\PublishThread.log"));

bool PublishThread::m_bExcuting = false;

PublishThread::PublishThread():wxThread(wxTHREAD_DETACHED)
{
}
void *PublishThread::Entry()
{
    ENMUtil::Log(dcLogFilePublishThread, _T("start Entry m_Avahicritsect.Enter \n "));

   // m_Avahicritsect.Enter();

    m_bExcuting = true;

    #if defined(__UNIX__)
    publishAvahi();
    #endif

    ENMUtil::Log(dcLogFilePublishThread, _T("end Entry \n "));

    return NULL;
}

void PublishThread::ExcuteFreeAvahi()
{
    #if defined(__UNIX__)
    freeAvahi();
    #endif
    ENMUtil::Log(dcLogFilePublishThread, _T("ExcuteFreeAvahi free \n "));
}

void PublishThread::OnExit()
{
    m_bExcuting = false ;

    ENMUtil::Log(dcLogFilePublishThread, _T("PublishThread::OnExit() m_Avahicritsect.Leave \n "));
}
