/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _PROXY_SETTINGS_H_
#define _PROXY_SETTINGS_H_

#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/statbox.h>
#include <wx/panel.h>
#include <wx/button.h>
#include <wx/dialog.h>

class ProxySettings: public wxDialog
{
	public:

		ProxySettings(wxWindow* parent);
		virtual ~ProxySettings();

		wxButton* m_BtnOK;
		wxStaticText* m_StPort;
		wxStaticBox* m_StProxyServer;
    wxTextCtrl* m_TcProxy;
		wxButton* m_BtnCancel;
		wxTextCtrl* m_TcPort;
		wxStaticText* m_StProxy;

private:
		static const long ID_TCPROXY;
		static const long ID_TCPORT;
		static const long ID_BUTTONCANCEL;
		static const long ID_BUTTONOK;

    void OnButtonCancelClick(wxCommandEvent& event);
    void OnButtonOKClick(wxCommandEvent& event);
		void OnInit(wxInitDialogEvent& event);

		DECLARE_EVENT_TABLE()
};

#endif
