/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ProfileEvent.h"

DEFINE_EVENT_TYPE(EVT_PROFILE)

ProfileEvent::ProfileEvent(unsigned int id, unsigned long code)
        : wxEvent(id, EVT_PROFILE)
        , m_iCode(code)
{
    //ctor
}

ProfileEvent::~ProfileEvent()
{
    //dtor
}

wxEvent* ProfileEvent::Clone() const
{
    return new ProfileEvent(*this);
}

unsigned long ProfileEvent::GetEventCode() const
{
    return m_iCode;
}
