/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef MESHSHAREMYINTERNETDLG_H
#define MESHSHAREMYINTERNETDLG_H

//(*Headers(MeshShareMyInternetDlg)
#include <wx/listctrl.h>
#include <wx/stattext.h>
#include <wx/panel.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)
#include "InternetStateEntity.h"
#include <vector>
using namespace std;
typedef vector<InternetStateEntity> InternetStateList;

class MeshShareMyInternetDlg: public wxDialog
{
	public:

		MeshShareMyInternetDlg(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~MeshShareMyInternetDlg();

		//(*Declarations(MeshShareMyInternetDlg)
		wxButton* ButtonRefresh;
		wxStaticBitmap* StaticBitmap1;
		wxButton* ButtonOK;
		wxListCtrl* m_list;
		wxPanel* Panel1;
		wxStaticText* StaticText1;
		wxButton* ButtonCancel;
		//*)
		int m_ReturnValue;

		bool Show(bool ifShow = true);

	protected:

		//(*Identifiers(MeshShareMyInternetDlg)
		static const long ID_LISTCTRL;
		static const long ID_STATICTEXT1;
		static const long ID_BUTTON_REFRESH;
		static const long ID_BUTTON_OK;
		static const long ID_BUTTON_CANCEL;
		static const long ID_STATICBITMAP1;
		static const long ID_PANEL1;
		//*)

	private:

        void OnCloseClicked(wxCloseEvent& event);
		//(*Handlers(MeshShareMyInternetDlg)
		void OnButtonRefreshClick(wxCommandEvent& event);
		void OnButtonOKClick(wxCommandEvent& event);
		void OnButtonCancelClick(wxCommandEvent& event);
		void OnTimerRegisterServer(wxTimerEvent& event);
//		bool Show(bool ifShow = true);
		//*)
		void DrawList();

		InternetStateList m_InternetStateList;
		static wxCriticalSection m_CriticalShareMy;
		wxTimer m_timerRegisterServer;
		static const int ID_TIMER_REGISTERSERVER;

		DECLARE_EVENT_TABLE()
};

#endif
