/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef MESHINFOMANAGER_H
#define MESHINFOMANAGER_H

#include "MeshServerEntity.h"
#include "InternetStateEntity.h"
#include "MeshUseOthersInternetDlg.h"
#include "DataCenterLinux.h"
#include <vector>
#include <algorithm>
using namespace std;

#define ADD 1
#define REMOVE 2
#define MODIFY 3
typedef vector<InternetStateEntity> InternetStateList;
typedef vector<InternetStateEntity>::iterator  InternetStateListIter;
typedef vector<MeshServerEntity> MeshServerInfoList;
typedef vector<MeshServerEntity>::iterator  MeshServerListIter;

class MeshInfoManager
{
    public:
        // Return instance
        static MeshInfoManager* GetInstance();
		//
        virtual ~MeshInfoManager();
		//



		void ChangeMeshClientMode(bool bIsMeshClient);

		bool GetMeshMode();

		void ChangeMeshServerMode(bool bIsMeshServer);

		bool GetMeshServerMode();

		const MeshServerInfoList& GetMeshServerInfoList();

		void GetInternetStateList(InternetStateList& internetStateList);

		void SetHostNameToServer();

        bool MeshHaveOpen();

        wxString GetEthName();

        void SetHostNameToClient();
        bool CheckWirelessLink();
        bool IsAdapterConnect(ENM_ADAPTER_TYPE AdpaterType);
        void TurnOffMesh();
        int GetAdapterIP(const char* ifname, char* ip);

     private:
		 //
        MeshInfoManager();
		//
		static MeshInfoManager* m_pMeshInfoManager;
        MeshServerEntity m_meshserverentity;
        bool m_bIsMeshClient;
        bool m_bIsMeshServer;

};

#endif // CLIENTPCINFOMANAGER_H
