/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef DISCONNECTBALLOON_H_INCLUDED
#define DISCONNECTBALLOON_H_INCLUDED

#include <wx/event.h>
#include <wx/timer.h>
#include <wx/frame.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/dcprint.h>
#include <wx/dcclient.h>
#include <wx/image.h>
#include <wx/statbmp.h>
#include <wx/gbsizer.h>
#include <wx/bmpbuttn.h>
#include <wx/hyperlink.h>
#include "BitmapDialog.h"

class DisConnectBalloon : public wxBitmapDialog
{
    public:
        DisConnectBalloon(wxWindow *dlg, const wxString& title);
        virtual ~DisConnectBalloon();

        void OnPaint(wxPaintEvent& event);

        wxStaticText* m_DisconnectTip;
        wxStaticText* m_DisconnectTitle;
		wxStaticText* m_ScanNetworkTip;
		wxBitmapButton* m_btnClose;
		wxBitmapButton* m_btnWarning;
		wxHyperlinkCtrl* m_HyperLinkCtrl;
		void SetScanHyperLink();

    protected:
		static const long ID_STATICTEXT_DISCONNECTTIP;
		static const long ID_STATICTEXT_DISCONNECTTITLE;
		static const long ID_STATICTEXT_SCANNETWORKTIP;
		static const long ID_BTN_WARNING;
		static const long ID_BTN_LINK;

    private:
        void OnHyperlinkClicked(wxHyperlinkEvent& event);
        void OnInit(wxInitDialogEvent& event);

        DECLARE_EVENT_TABLE();

};

#endif // DISCONNECTBALLOON_H_INCLUDED
