/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef WXBITMAPDIALOG_H
#define WXBITMAPDIALOG_H

#include <wx/dialog.h>
#include <wx/bitmap.h>
#include <wx/frame.h>
#include <wx/dc.h>
#include <wx/dcclient.h>

class wxBitmapDialog : public wxDialog
{
public:
    wxBitmapDialog(wxBitmap bitmap, wxWindow* parent, wxWindowID id, const wxString& title);
    wxBitmapDialog(const wxBitmap& bitmap, wxWindow* parent, const wxString& title);
    virtual ~wxBitmapDialog();

protected:
    wxBitmap m_bitmap;

private:
    void Init();

    bool m_hasShape;
    wxPoint  m_diff;

    void SetWindowShape();

    void OnMouseLeftDown(wxMouseEvent& event);
    void OnMouseLeftUp(wxMouseEvent& event);
    void OnMouseMove(wxMouseEvent& event);

    void OnEraseBackground(wxEraseEvent& event);
    void OnSize(wxSizeEvent& event);
    void OnPaint(wxPaintEvent& event);
    void OnWindowCreate(wxWindowCreateEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif // WXBITMAPDIALOG_H
