/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _AUTORUN_SETTINGS_H_
#define _AUTORUN_SETTINGS_H_

#include <wx/listbox.h>
#include <wx/button.h>
#include <wx/dialog.h>

class AutoRunSettings : public wxDialog
{
public:
    AutoRunSettings(wxWindow* parent, wxWindowID id = wxID_ANY);
    virtual ~AutoRunSettings();
    virtual void SetApplications(const wxArrayString& apps);
    virtual wxArrayString GetApplications() const;

private:
    static const long ID_LIST_APP;
    static const long ID_BTN_ADD;
    static const long ID_BTN_DELETE;
    static const long ID_BTN_OK;
    static const long ID_BTN_CANCEL;

    wxButton* m_btnDelete;
    wxButton* m_btnAdd;
    wxButton* m_btnOK;
    wxButton* m_btnCancel;
    wxListBox* m_listApp;
    wxArrayString m_arrayApps;

    //called when click add button
    void OnButtonAdd(wxCommandEvent& event);
    //called when click delete button
    void OnButtonDelete(wxCommandEvent& event);
    //called when click ok button
    void OnButtonOK(wxCommandEvent& event);
    //called when click cancel button
    void OnButtonCancel(wxCommandEvent& event);
    //called when select a column in list
    void OnListApplicationSelected(wxCommandEvent& event);
    void OnInit(wxInitDialogEvent& event);
    void CloseDialog(int retCode = wxID_CANCEL);

    DECLARE_EVENT_TABLE()
};

#endif // _AUTORUN_SETTINGS_H_
