/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ACCESS_POINT_SORTER_H
#define _ACCESS_POINT_SORTER_H

#include <wx/wx.h>
#include "wlan.h"

class AccessPointSorter : public wxObject
{
    public:
        AccessPointSorter(int columnCount);
        virtual ~AccessPointSorter();

        void Reset();   //reset
        bool IsSortEnable(int column) const;    //checking whether can sort by specific column
        bool SetSortEnable(int column, bool enable);    //setting whether can sort by specific column
        bool SetSortOrder(int column, bool ascending = true);   //setting order when sorting by specific column
        bool Sort(APStatus* apArray, int arraySize, int column, bool insc = true);  //compare specific columns

    private:
        bool* m_baSortEnable;
        bool* m_baSortOrder;
        int m_iColumnCount;

        int CompareStringNoCase(const char* str1, const char* str2);
};

#endif // _ACCESS_POINT_SORTER_H
