# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
Elisa Command Line Options and Arguments parsing
"""

__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

import platform
import sys
from elisa.core import __version__

from twisted.python import usage

class Options(usage.Options):
    """
    Application's command-line options definitions
    """

    optFlags = [['version', '', 'Show elisa version.'],
                ['twisted-version', '', 'Show twisted version.'],
                ['tracebacks', 't', 'Display tracebacks.'],
                ['log', 'l', 'Log output in elisa.log files.'],
                ['shell', '', 'Open an interactive shell in the terminal.'],
                ['headless', '', 'Start in headless mode.'],
                ['force-startup', '', 'Start even another instance is running.'],
                ['fullscreen', 'f', 'Start fullscreen.'],
                ['unfullscreen', 'u', 'Start unfullscreen.'],
                ['nosplash', 'n', 'Do not show the splashscreen.'],
               ]

    optParameters = [['import', 'i', None, 'The script to import, used by \
                                            windows only.'],
                     ['config-file', 'c', None, 'The configuration file.']
                    ]


    tracebacks = False

    def parseArgs(self, *args):
        self['files'] = args

    def opt_twisted_version(self):
        return usage.Options.opt_version(self)

    def opt_version(self):
        print 'Elisa version %s' % __version__
        sys.exit(0)
        
    def opt_import(self):
        if platform.system() != 'Windows':
            print "-i (--import) option works only under windows"
            sys.exit(0)
