# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>

"""
messages related to network services and shares
"""

from elisa.core.components.message import Message

class NetworkServiceAppearedMessage(Message):
    """
    A new NetworkService is detected and the service sends this message over the
    bus to allow anybody to react on it.

    @ivar uid:      the unique id of this service (compare it with yours)
    @type uid:      C{unicode}
    @ivar model:    the model representating the new service
    @type model:    C{elisa.plugins.base.models.network.NetworkServiceModel}
    """
    def __init__(self, model=None):
        super(NetworkServiceAppearedMessage, self).__init__()
        self.model = model

    @property
    def uid(self):
        return self.model.uid


class NetworkServiceDisappearedMessage(Message):
    """
    A NetworkService disappeared from the network so this message is sent over
    the bus and every body can react on it.

    @ivar uid:    the unique id of this service (compare it with yours)
    @type uid:    C{unicode}
    """
    def __init__(self, uid=None):
        super(NetworkServiceDisappearedMessage, self).__init__()
        self.uid = uid


